package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.util.WaarListFactory;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class CompareUpgradedToInstalledRelvar extends SiraPriseWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic() throws WaarException {
		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue("UPGRADEDSERVER") != null && getPresentationValue("SYSGENNEDSERVER") != null && getPresentationValue("UPGRADEDPORT") != null && getPresentationValue("SYSGENNEDPORT") != null) {    //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic() throws WaarException {
		String relvarName = ((GenericStringValue)getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();

		DBConnection connectionToUpgradedServer = getDBConnection(((GenericStringValue)getPresentationValue("UPGRADEDSERVER")).getString().trim(), ((GenericIntegerValue)getPresentationValue("UPGRADEDPORT")).getInteger(), getUserLocale()); //$NON-NLS-1$ //$NON-NLS-2$
		DBConnection connectionToSysgennedServer = getDBConnection(((GenericStringValue)getPresentationValue("SYSGENNEDSERVER")).getString().trim(), ((GenericIntegerValue)getPresentationValue("SYSGENNEDPORT")).getInteger(), getUserLocale()); //$NON-NLS-1$ //$NON-NLS-2$

		try {
			String rtx_upgraded = connectionToUpgradedServer.startTransaction().execQueryAndEndTransaction(relvarName).printValueEscapedWithTypeNames();
			DBTransaction sysgennedServerTransaction = connectionToSysgennedServer.startTransaction();
			String rtx_sysgenned = sysgennedServerTransaction.execQuery(relvarName).printValueEscapedWithTypeNames();
			setPresentationValue("UPGRADEDNOTINSYSGENNED", WaarListFactory.varColumnListFromSiraPriseQueryResponse("UPGRADEDNOTINSYSGENNED", sysgennedServerTransaction.execQuery("MINUS(" + rtx_upgraded + "," + rtx_sysgenned + ")"), getUserLocale())); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			setPresentationValue("SYSGENNEDNOTINUPGRADED", WaarListFactory.varColumnListFromSiraPriseQueryResponse("SYSGENNEDNOTINUPGRADED", sysgennedServerTransaction.execQuery("MINUS(" + rtx_sysgenned + "," + rtx_upgraded + ")"), getUserLocale())); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			sysgennedServerTransaction.end(true);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} finally {
			connectionToSysgennedServer.close();
			connectionToUpgradedServer.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription(String language) {
		return I18N.getString(getUserLocale(), "CompareUpgradedToInstalledRelvar.Text");  //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit() {
		return false;
	}
}