package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.util.WaarListFactory;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to type queries and have them evaluated by a specified sira_prise server
 * 
 * @author Erwin
 */
public class Console extends SiraPriseWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction#doActionLogic(java.lang.String)
	 */
	public void doActionLogic(String action) throws WaarException {
		if (action.equalsIgnoreCase("TOQUERY")) { //$NON-NLS-1$
			GenericStringValue wv_server = (GenericStringValue)getPresentationValue(SiraPriseWebClientFunction.SERVER);
			GenericIntegerValue wv_port = (GenericIntegerValue)getPresentationValue(DBConnectionProperties.PORT);
			setPresentation("Console_query"); //$NON-NLS-1$
			setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
			setPresentationValue(DBConnectionProperties.PORT, wv_port);
		} else {
			if (action.equalsIgnoreCase("TOCOMMAND")) { //$NON-NLS-1$
				GenericStringValue wv_server = (GenericStringValue)getPresentationValue(SiraPriseWebClientFunction.SERVER);
				GenericIntegerValue wv_port = (GenericIntegerValue)getPresentationValue(DBConnectionProperties.PORT);
				setPresentation("Console_updatecommand"); //$NON-NLS-1$
				setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
				setPresentationValue(DBConnectionProperties.PORT, wv_port);
			} else {
				super.doActionLogic(action);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic() throws WaarException {
		GenericStringValue wv_server = (GenericStringValue)getPresentationValue(SiraPriseWebClientFunction.SERVER);
		GenericIntegerValue wv_port = (GenericIntegerValue)getPresentationValue(DBConnectionProperties.PORT);
		String server = wv_server.getString().trim();
		int port = wv_port.getInteger();

		if (getPresentation().getName().equalsIgnoreCase("CONSOLE_QUERY")) { //$NON-NLS-1$
			DBConnection dbc = getDBConnection(server, port, getUserLocale());
			try {
				setPresentationValue("QUERYRESULT", WaarListFactory.varColumnListFromSiraPriseQueryResponse("QUERYRESULT", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.OFF).execQueryAndEndTransaction(((GenericStringValue)getPresentationValue("QUERY")).getString().trim()), getUserLocale())); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		} else {
			GenericStringValue wv_command = (GenericStringValue)getPresentationValue("COMMAND"); //$NON-NLS-1$
			String command = wv_command.getString().trim();
			DBConnection dbc = getDBConnection(server, port, getUserLocale());
			try {
				AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.OFF).execDmlCommandAndEndTransaction(command); //$NON-NLS-1$
				//				String responseText = rsp.getResponseText();
				if (rsp != null) {
					setPresentation("Console_querycommand"); //$NON-NLS-1$
					setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
					setPresentationValue(DBConnectionProperties.PORT, wv_port);
					setPresentationValue("COMMAND", wv_command); //$NON-NLS-1$

					//parse command result tuple(...)tuple(...)
					setPresentationValue("QUERYRESULT", WaarListFactory.varColumnListFromSiraPriseQueryResponse("QUERYRESULT", rsp, getUserLocale())); //$NON-NLS-1$ //$NON-NLS-2$
				} else {
					setPresentation("Console_updatecommand"); //$NON-NLS-1$
					setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
					setPresentationValue(DBConnectionProperties.PORT, wv_port);
					setPresentationValue("COMMAND", wv_command); //$NON-NLS-1$

					//				    setPresentationValue("UPDATERESULT", responseText); //$NON-NLS-1$
				}
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName() {
		return "Console_query"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription(String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "Console.Text"), new String[]{}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit() {
		return false;
	}
}