package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ConstrainedType;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a constrained-type definition
 * 
 * @author Erwin
 */
public class ConstrainedTypesDelete extends ConstrainedTypesWebClientFunction {

	/**
	 * Flag telling whether the function can be left or not
	 */
	private boolean leave = false;

	/**
	 * Queries the catalog for the selected type and displays the delete confirm presentation
	 * 
	 * @throws WaarException
	 */
	private void processSelectedType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		ConstrainedType constrainedType = getConstrainedType(sirapriseServer);

		setPresentation("ConstrainedTypesDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);

		saveInFunctionContext(RELVARNAMES.CONSTRAINEDTYPE, constrainedType);
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, constrainedType.getTypeName());
		setPresentationValue(ATTRIBUTENAMES.BASETYPE, constrainedType.getBaseTypeName());
		setPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION, constrainedType.getExpression());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null) {
			processSelectedType();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(CONSTRAINEDTYPESSELECT)) {
			// filename entered, ask confirmation
			processSelectedType();
		} else {
			// confirmation entered, delete type
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

			ConstrainedType constrainedType = (ConstrainedType) getFromFunctionContextMandatory(RELVARNAMES.CONSTRAINEDTYPE);

			setPresentationValue(ATTRIBUTENAMES.TYPENAME, constrainedType.getTypeName());
			setPresentationValue(ATTRIBUTENAMES.BASETYPE, constrainedType.getBaseTypeName());
			setPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION, constrainedType.getExpression());

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(constrainedType.dbDeleteCommand(RELVARNAMES.CONSTRAINEDTYPE)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return CONSTRAINEDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ConstrainedTypesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}