package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ConstrainedType;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a constrained type
 * 
 * @author Erwin
 */
public class ConstrainedTypesManage extends ConstrainedTypesWebClientFunction {

	/**
	 * Queries the catalog for the selected type and displays the "manage type details" presentation
	 * 
	 * @throws WaarException
	 */
	private void processSelectedType() throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		ConstrainedType constrainedType = getConstrainedType(sirapriseServer);
		setPresentation("ConstrainedTypesManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		saveInFunctionContext(RELVARNAMES.CONSTRAINEDTYPE, constrainedType);
		setPresentationValue(ATTRIBUTENAMES.TYPENAME, constrainedType.getTypeName());
		setPresentationValue(ATTRIBUTENAMES.BASETYPE, constrainedType.getBaseTypeName());
		setPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION, constrainedType.getExpression());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic() throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.TYPENAME) != null) {
			processSelectedType();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic() throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(CONSTRAINEDTYPESSELECT)) {
			//selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedType();
		} else {
			// <OK> clicked on managedetails presentation ; try to modify type definition
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			ConstrainedType constrainedType = (ConstrainedType) getFromFunctionContextMandatory(RELVARNAMES.CONSTRAINEDTYPE);
			constrainedType.setTypeName(((GenericStringValue)getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim());
			constrainedType.setBaseTypeName(((GenericStringValue)getPresentationValue(ATTRIBUTENAMES.BASETYPE)).getString());
			constrainedType.setExpression(((GenericStringValue)getPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION)).getString());

			try {
				DmlUpdateCommand cmd = constrainedType.dbUpdateCommand(RELVARNAMES.CONSTRAINEDTYPE);
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(cmd); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e1) {
				
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic() throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName() {
		return CONSTRAINEDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription(String language) {
		return I18N.getString(getUserLocale(), "ConstrainedTypesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit() {
		return false;
	}
}