/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.ConstrainedType;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class ConstrainedTypesWebClientFunction extends TypesWebClientFunction {

	/**
	 * 
	 */
	static final String CONSTRAINEDTYPESSELECT = "ConstrainedTypesSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws ConstrainedTypeNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	ConstrainedType getConstrainedType (SiraPriseServer sirapriseServer) throws NoConnectionException, ConstrainedTypeNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		String typeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.TYPENAME)).getString().trim();

		// Get the basetypename and the constraintexpression to save it in the sessioncontext
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation tuples = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.CONSTRAINEDTYPE + ",EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			if (tuples.size() < 1) {
				throw new ConstrainedTypeNotFoundException(typeName, getUserLocale());
			}
			return tuples.toObjectCollection(ConstrainedType.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
