package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a new dataspace in a dbms file
 * 
 * @author Erwin
 */
public class DataSpaceCreate extends DataSpaceWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			WaarValue wv_extents = getPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT);
			DataSpace dataspace = new DataSpace(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.PAGECOUNT)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS)).getInteger(), wv_extents == null ? 0 : ((GenericIntegerValue) wv_extents).getInteger());
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { new DmlAddCommand(RELVARNAMES.STORAGESPACE, dataspace), new DmlAddCommand(RELVARNAMES.DATASPACE, dataspace) }); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DataSpaceCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}