package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.LinkedList;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a data space from a dbms file
 * 
 * @author Erwin
 */
public class DataSpaceDelete extends DataSpaceWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedDataSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DataSpace dataSpace = getDataSpace(sirapriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger());

		setPresentation("DataSpaceDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);

		setPresentationValue(ATTRIBUTENAMES.FILENAME, dataSpace.getFileName());
		setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, dataSpace.getStorageSpaceID());

		setPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD, dataSpace.getGapCompressionThreshold());
		setPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS, dataSpace.getMaximumGaps());
		setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, dataSpace.getPageCount());
		setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, dataSpace.getExtentsCount());

		saveInFunctionContext(RELVARNAMES.DATASPACE, dataSpace);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedDataSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// errorcode entered, ask confirmation
			processSelectedDataSpace();
		} else {
			DataSpace dataSpace = (DataSpace) getFromFunctionContextMandatory(RELVARNAMES.DATASPACE);
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new LinkedList<DmlDeleteCommand>(Arrays.asList(new DmlDeleteCommand[] { new DmlDeleteCommand(RELVARNAMES.DATASPACE, dataSpace), new DmlDeleteCommand(RELVARNAMES.STORAGESPACE, dataSpace) }))); //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DataSpaceDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}