package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.WAAR.PresentationLayer.GenericIntegerValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.WaarException;
import be.erwinsmout.MyMessageFormat;

/**
 * The function to manage data space details
 * 
 * @author Erwin
 */
public class DataSpaceManage extends DataSpaceWebClientFunction {

	/**
	 * Leave the function or not after completion
	 */
	boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedDataSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DataSpace dataSpace = getDataSpace(sirapriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger());

		setPresentation("DataSpaceManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.FILENAME, dataSpace.getFileName());
		setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, dataSpace.getStorageSpaceID());

		setPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD, dataSpace.getGapCompressionThreshold());
		setPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS, dataSpace.getMaximumGaps());
		setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, dataSpace.getPageCount());
		setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, dataSpace.getExtentsCount());

		saveInFunctionContext(RELVARNAMES.DATASPACE, dataSpace);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedDataSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedDataSpace();
		} else {
			DataSpace dataSpace = (DataSpace) getFromFunctionContextMandatory(RELVARNAMES.DATASPACE);
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dataSpace.setExtentsCount(((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT)).getInteger());
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbUpdate(RELVARNAMES.STORAGESPACE, dataSpace); //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}

			setPresentationValue(ATTRIBUTENAMES.FILENAME, dataSpace.getFileName());
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, dataSpace.getStorageSpaceID());
			setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, dataSpace.getPageCount());
			setPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS, dataSpace.getMaximumGaps());
			setPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD, dataSpace.getGapCompressionThreshold());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "DataSpaceManage.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}