/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class DataSpaceWebClientFunction extends StorageSpaceWebClientFunction {

	/**
	 * @param sirapriseServer
	 * @param fileName
	 * @param storageSpaceID
	 * @return
	 * @throws NoConnectionException
	 * @throws DataSpaceNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	DataSpace getDataSpace (SiraPriseServer sirapriseServer, String fileName, int storageSpaceID) throws NoConnectionException, DataSpaceNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation r_dataSpace = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(JOIN(" + RELVARNAMES.DATASPACE + "," + RELVARNAMES.STORAGESPACE + "),AND(EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + storageSpaceID + ")),EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + "))))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			if (r_dataSpace.size() < 1) {
				// filename not found
				throw new DataSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}
			return DBObjectFactory.getObject(r_dataSpace.iterator().next(), DataSpace.class);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}
}
