package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.DatabaseConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a databaseconstraint and possibly its corresponding constraintmessagetext
 * 
 * @author Erwin
 */
public class DatabaseConstraintsDelete extends DatabaseConstraintsWebClientFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedDatabaseConstraint ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();

		DatabaseConstraint databaseConstraint = getDatabaseConstraint(sirapriseServer, errorCode);

		saveInFunctionContext(RELVARNAMES.DATABASECONSTRAINT, databaseConstraint);

		setPresentation("DatabaseConstraintsDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, databaseConstraint.getErrorCode());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, databaseConstraint.getLabel());
		setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, databaseConstraint.getExpression());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, databaseConstraint.getMessageText());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedDatabaseConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(DATABASECONSTRAINTSSELECT)) {
			// errorcode entered, ask confirmation
			processSelectedDatabaseConstraint();
		} else {
			// confirmation entered, delete constraint
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			DatabaseConstraint databaseConstraint = (DatabaseConstraint) getFromFunctionContextMandatory(RELVARNAMES.DATABASECONSTRAINT);

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { databaseConstraint.dbDeleteCommand(RELVARNAMES.DATABASECONSTRAINT), databaseConstraint.dbUnAssertCommand(RELVARNAMES.CONSTRAINTMESSAGETEXT) }); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return DATABASECONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DatabaseConstraintsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}