package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.DatabaseConstraint;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a database constraint
 * 
 * @author Erwin
 */
public class DatabaseConstraintsManage extends DatabaseConstraintsWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedDatabaseConstraint ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DatabaseConstraint databaseConstraint = getDatabaseConstraint(sirapriseServer, ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger());

		saveInFunctionContext(RELVARNAMES.DATABASECONSTRAINT, databaseConstraint);

		setPresentation("DatabaseConstraintsManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, databaseConstraint.getErrorCode());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL, databaseConstraint.getLabel());
		setPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION, databaseConstraint.getExpression());
		setPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT, databaseConstraint.getMessageText());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedDatabaseConstraint();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(DATABASECONSTRAINTSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedDatabaseConstraint();
		} else {
			// new dbms file details entered, update the catalog
			final DatabaseConstraint databaseConstraint = (DatabaseConstraint) getFromFunctionContextMandatory(RELVARNAMES.DATABASECONSTRAINT);
			databaseConstraint.setErrorCode(((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger());
			databaseConstraint.setExpression(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.SP_EXPRESSION)).getString().trim());
			databaseConstraint.setLabel(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTLABEL)).getString().trim());

			GenericStringValue wv_newConstraintMessageText = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT);
			if (wv_newConstraintMessageText != null) {
				databaseConstraint.setMessageText(wv_newConstraintMessageText.getString().trim());
			} else {
				databaseConstraint.setMessageText(""); //$NON-NLS-1$
			}

			try {
				DmlAssignmentCommand cmd = databaseConstraint.smartUpdateComand();
				DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommand(cmd); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			} catch (NoUpdatesException e2) {

			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return DATABASECONSTRAINTSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DatabaseConstraintsManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}