package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.HashSet; //import java.util.logging.Logger;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to produce an overview of database constraints
 * 
 * @author Erwin
 */
public class DatabaseConstraintsOverview extends DatabaseConstraintsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null || getPresentationValue("ERRORCODEFROM") != null || getPresentationValue("ERRORCODETO") != null) { //$NON-NLS-1$ //$NON-NLS-2$
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String expression;
		String databaseConstraintCheckExpression = RELVARNAMES.DATABASECONSTRAINTCHECK;
		if (((LogicalValue) getPresentationValue("SELECTBYOPERATIONTYPE")).getValue()) { //$NON-NLS-1$
			NumberedEnumerationValue wv_operationType = (NumberedEnumerationValue) getPresentationValue(ATTRIBUTENAMES.OPERATIONTYPE);
			if (wv_operationType != null) {
				databaseConstraintCheckExpression = "RESTRICT(" + databaseConstraintCheckExpression + ",EQ(" + ATTRIBUTENAMES.OPERATIONTYPE + ",INT(" + wv_operationType.getIntegerValue() + ")))";    //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}
		}

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_relvarNamePattern = (GenericStringValue) getPresentationValue("RELVARNAMEPATTERN"); //$NON-NLS-1$
		if (wv_relvarName != null) {
			if (wv_relvarNamePattern != null) {
				throw new BothNameAndPatternNotAllowedException(getUserLocale());
			} else {
				expression = "SEMIJOIN(" + RELVARNAMES.DATABASECONSTRAINT + ",PROJECT(JOIN(" + databaseConstraintCheckExpression + "," + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(wv_relvarName.getString()), ATTRIBUTENAMES.RELVARNAME, TYPENAMES.NAME) + "),(" + ATTRIBUTENAMES.ERRORCODE + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
		} else {
			if (wv_relvarNamePattern != null) {
				expression = "SEMIJOIN(" + RELVARNAMES.DATABASECONSTRAINT + ",PROJECT(RESTRICT(" + databaseConstraintCheckExpression + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + BracketParser.meta(wv_relvarNamePattern.getString().trim()) + "))),(" + ATTRIBUTENAMES.ERRORCODE + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ 
			} else {
				expression = RELVARNAMES.DATABASECONSTRAINT;
			}
		}

		GenericIntegerValue wv_errorCodeFrom = (GenericIntegerValue) getPresentationValue("ERRORCODEFROM"); //$NON-NLS-1$
		if (wv_errorCodeFrom != null) {
			expression = "RESTRICT(" + expression + ",GT(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + (Math.max(wv_errorCodeFrom.getInteger(), 0) - 1) + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
		}

		GenericIntegerValue wv_errorCodeTo = (GenericIntegerValue) getPresentationValue("ERRORCODETO"); //$NON-NLS-1$
		if (wv_errorCodeTo != null) {
			expression = "RESTRICT(" + expression + ",GT(LONG(" + wv_errorCodeTo.getInteger() + ")," + ATTRIBUTENAMES.ERRORCODE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("DATABASECONSTRAINTLIST", getWAARListValue("DATABASECONSTRAINTLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(expression), new HashSet<String>(Arrays.asList(new String[] { ATTRIBUTENAMES.SP_EXPRESSION, ATTRIBUTENAMES.CONSTRAINTLABEL })))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DatabaseConstraintsOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}