/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DatabaseConstraint;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 * 
 */
public abstract class DatabaseConstraintsWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String DATABASECONSTRAINTSSELECT = "DatabaseConstraintsSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @param errorCode
	 * @return
	 * @throws NoConnectionException
	 * @throws DatabaseConstraintNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final DatabaseConstraint getDatabaseConstraint (SiraPriseServer sirapriseServer, long errorCode) throws NoConnectionException, DatabaseConstraintNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation tuples = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(LEFTJOIN(" + RELVARNAMES.DATABASECONSTRAINT + "," + RELVARNAMES.CONSTRAINTMESSAGETEXT + "," + ATTRIBUTENAMES.CONSTRAINTMESSAGETEXT + "(STRING())),EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			if (tuples.size() < 1) {
				throw new DatabaseConstraintNotFoundException(errorCode, getUserLocale());
			}
			return tuples.toObjectCollection(DatabaseConstraint.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
