package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.DataSpace;
import be.SIRAPRISE.client.jsba.DbmsFile;
import be.SIRAPRISE.client.jsba.HashingIndexSpace;
import be.SIRAPRISE.client.jsba.MultiHashingIndexSpace;
import be.SIRAPRISE.client.jsba.StorageSpace;
import be.SIRAPRISE.client.jsba.TreeIndexSpace;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to delete an existing sira_prise dbms file
 * 
 * @author Erwin
 */
public class DbmsFilesDelete extends DbmsFilesWebClientFunction {

	/**
	 * 
	 */
	private static final String DBOBJECTSTOBEDELETED = "DBOBJECTSTOBEDELETED"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRMATION = "DbmsFilesDeleteConfirm"; //$NON-NLS-1$

	/**
	 * Leave the function or not after exit
	 */
	private boolean leave = false;

	/**
	 * Processes the delete confirmation
	 * 
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 */
	@SuppressWarnings("unchecked")
	private void processDeleteConfirmation ( ) throws WaarException {
		// confirmation entered, delete file and storage spaces
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			Map<String, Collection<? extends DBObject>> dbObjectsToBeDeleted = (Map<String, Collection<? extends DBObject>>) getFromFunctionContextMandatory(DBOBJECTSTOBEDELETED);
			Set<DmlDeleteCommand> deleteCommands = new HashSet<DmlDeleteCommand>();
			for (Entry<String, Collection<? extends DBObject>> me : dbObjectsToBeDeleted.entrySet()) {
				for (DBObject dbObjectToBeDeleted : me.getValue()) {
					deleteCommands.add(startTransaction.dbDeleteCommand(me.getKey(), dbObjectToBeDeleted));
				}
			}
			startTransaction.execMultipleStatementAndEndTransaction(deleteCommands);
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * Reads the data for the selected file from the catalog and displays the "Manage file details" presentation (or displays an error message)
	 * 
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		GenericStringValue wv_fileName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME);
		String fileName = wv_fileName.getString();

		// set the pagesize in the context so that when ok is pressed, the delete attempted will be with a tuple constant based on the pagesize obtained here
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String c_fileName = "EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			AbstractRelation r_dbmsFile = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.DBMSFILE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_storageSpaces = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.STORAGESPACE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
//			Relation r_storageSpaceExtents = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.STORAGESPACEEXTENTS + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_dataSpaces = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.DATASPACE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_hashingIndexSpaces = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.HASHINGINDEXSPACE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_multiHashingIndexSpaces = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.MULTIHASHINGINDEXSPACE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_treeIndexSpaces = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.TREEINDEXSPACE + "," + c_fileName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (r_dbmsFile.size() < 1) {
				throw new DbmsFileNotFoundException(fileName, getUserLocale());
			}

			setPresentation(PRESENTATIONNAME_DELETECONFIRMATION);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.FILENAME, wv_fileName);

			Map<String, Collection<?>> dbObjectsToBeDeleted = new HashMap<String, Collection<?>>();
			dbObjectsToBeDeleted.put(RELVARNAMES.DBMSFILE, r_dbmsFile.toObjectCollection(DbmsFile.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.STORAGESPACE, r_storageSpaces.toObjectCollection(StorageSpace.class));
//			dbObjectsToBeDeleted.put(RELVARNAMES.STORAGESPACEEXTENTS, r_storageSpaceExtents.toObjectCollection(StorageSpaceExtent.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.DATASPACE, r_dataSpaces.toObjectCollection(DataSpace.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.HASHINGINDEXSPACE, r_hashingIndexSpaces.toObjectCollection(HashingIndexSpace.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.MULTIHASHINGINDEXSPACE, r_multiHashingIndexSpaces.toObjectCollection(MultiHashingIndexSpace.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.TREEINDEXSPACE, r_treeIndexSpaces.toObjectCollection(TreeIndexSpace.class));
			saveInFunctionContext(DBOBJECTSTOBEDELETED, dbObjectsToBeDeleted);

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null) {
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(DBMSFILESSELECT)) {
			// filename entered, ask confirmation
			processSelectionPresentation();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return DBMSFILESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "DbmsFilesDelete.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}