package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.DbmsFile;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of a dbms file
 * 
 * @author Erwin
 */
public class DbmsFilesManage extends DbmsFilesWebClientFunction {

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_MANAGEFILEDETAILS = "DbmsFilesManageDetails"; //$NON-NLS-1$

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 */
	private void processDbmsFileDetails ( ) throws WaarException {
		// new dbms file details entered, update the catalog
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DbmsFile dbmsFile = (DbmsFile) getFromFunctionContextMandatory(RELVARNAMES.DBMSFILE);
		dbmsFile.setFileName(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim());
		dbmsFile.setPageSize(((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.PAGESIZE)).getInteger());

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbUpdateAndEndTransaction(RELVARNAMES.DBMSFILE, dbmsFile); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation r_dbmsFile = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(getQuery(fileName)); //$NON-NLS-1$
			if (r_dbmsFile.size() < 1) {
				throw new DbmsFileNotFoundException(fileName, getUserLocale());
			}

			DbmsFile dbmsFile = DBObjectFactory.getObject(r_dbmsFile.iterator().next(), DbmsFile.class);

			setPresentation(PRESENTATIONNAME_MANAGEFILEDETAILS);
			setSiraPriseServerPortPresentationValues(sirapriseServer);

			setPresentationValue(ATTRIBUTENAMES.FILENAME, fileName);
			setPresentationValue(ATTRIBUTENAMES.PAGESIZE, dbmsFile.getPageSize());

			saveInFunctionContext(RELVARNAMES.DBMSFILE, dbmsFile);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null) {
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(DBMSFILESSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectionPresentation();
		} else {
			processDbmsFileDetails();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		// this means we've come back from 'delete this file', either after delete or after cancel.
		// 1) check if the tuple still exists. If not, switch to the initial presentation with an empty filename.
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			if (dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(getQuery(((DbmsFile) getFromFunctionContextMandatory(RELVARNAMES.DBMSFILE)).getFileName())).size() == 0) { //$NON-NLS-1$
				setPresentation(DBMSFILESSELECT);
			}
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return DBMSFILESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "DbmsFilesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}