package be.SIRAPRISE.webclient;

import java.util.Iterator;
import java.util.TreeMap;
import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to display an overview of existing dbms files
 * 
 * @author Erwin
 */
public class DbmsFilesOverview extends DbmsFilesWebClientFunction {

	/**
	 * The name of the list attribute on the presentation
	 */
	private static final String FILELIST = "FILELIST"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String NAMEPATTERN = "NAMEPATTERN"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String ORDERBYNAME = "ORDERBYNAME"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_namePattern = (GenericStringValue) getPresentationValue(NAMEPATTERN);
		String query;
		if (wv_namePattern != null) {
			query = "RESTRICT(" + RELVARNAMES.DBMSFILE + ",MATCHES(THE_STRING(" + ATTRIBUTENAMES.FILENAME + "),STRING(" + BracketParser.meta(wv_namePattern.getString()) + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		} else {
			query = RELVARNAMES.DBMSFILE;
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation r_dbmsFile = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(query); //$NON-NLS-1$

			AbstractRelation orderedTuples;
			if (((LogicalValue) getPresentationValue(ORDERBYNAME)).getValue()) {
				// Order the tuples in "lexicographical" order
				TreeMap<String, Tuple> ordered = new TreeMap<String, Tuple>();
				Iterator<Tuple> i_tuples = r_dbmsFile.iterator();
				while (i_tuples.hasNext()) {
					AbstractTuple tuple = (AbstractTuple) i_tuples.next();
					ordered.put(tuple.value(ATTRIBUTENAMES.FILENAME), tuple);
				}
				orderedTuples = new InsertionOrderRelation(r_dbmsFile.getHeading());
				Iterator<Tuple> i_ordered = ordered.values().iterator();
				while (i_ordered.hasNext()) {
					orderedTuples.addTupleWithoutHeadingCheck(i_ordered.next());
				}
			} else {
				orderedTuples = r_dbmsFile;
			}

			setPresentationValue(FILELIST, getWAARListValue(FILELIST, orderedTuples, null));
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "DbmsFilesOverview.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}