package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.LinkedList;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.HashingIndexSpace;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to delete a hashing index space from a dbms file
 * 
 * @author Erwin
 */
public class HashingIndexSpaceDelete extends HashingIndexSpaceWebClientFunction {

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRMATION = "HashingIndexSpaceDeleteConfirm"; //$NON-NLS-1$

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	private void processDeleteConfirmation ( ) throws WaarException, NoConnectionException, DBProblem, WAARApplicationException {
		HashingIndexSpace hashingIndexSpace = (HashingIndexSpace) getFromFunctionContextMandatory(RELVARNAMES.HASHINGINDEXSPACE);
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new LinkedList<DmlAssignmentCommand>(Arrays.asList(new DmlAssignmentCommand[] { hashingIndexSpace.dbDeleteCommand(RELVARNAMES.HASHINGINDEXSPACE), hashingIndexSpace.dbDeleteCommand(RELVARNAMES.STORAGESPACE) }))); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedHashingIndexSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		HashingIndexSpace hashingIndexSpace = getHashingIndexSpace(sirapriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger());

		setPresentation(PRESENTATIONNAME_DELETECONFIRMATION);
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.FILENAME, hashingIndexSpace.getFileName());
		setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, hashingIndexSpace.getStorageSpaceID());
		setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, hashingIndexSpace.getPageCount());
		setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, hashingIndexSpace.getExtentsCount());

		saveInFunctionContext(RELVARNAMES.HASHINGINDEXSPACE, hashingIndexSpace);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedHashingIndexSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// errorcode entered, ask confirmation
			processSelectedHashingIndexSpace();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "HashingIndexSpaceDelete.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}