package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.HashingIndexSpace;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin
 */
public class HashingIndexSpaceManage extends HashingIndexSpaceWebClientFunction {

	/**
	 * Leave the function or not after completion
	 */
	boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedHashingIndexSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		HashingIndexSpace hashingIndexSpace = getHashingIndexSpace(sirapriseServer, ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger());

		setPresentation("HashingIndexSpaceManageDetails"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);

		setPresentationValue(ATTRIBUTENAMES.FILENAME, hashingIndexSpace.getFileName());
		setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, hashingIndexSpace.getStorageSpaceID());
		setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, hashingIndexSpace.getPageCount());
		setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, hashingIndexSpace.getExtentsCount());

		saveInFunctionContext(RELVARNAMES.HASHINGINDEXSPACE, hashingIndexSpace);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedHashingIndexSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("StorageSpaceSelect")) { //$NON-NLS-1$
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedHashingIndexSpace();
		} else {
			HashingIndexSpace hashingIndexSpace = (HashingIndexSpace) getFromFunctionContextMandatory(RELVARNAMES.HASHINGINDEXSPACE);
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				hashingIndexSpace.setExtentsCount(((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT)).getInteger());
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).dbUpdate(RELVARNAMES.STORAGESPACE, hashingIndexSpace); //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}

			setPresentationValue(ATTRIBUTENAMES.FILENAME, hashingIndexSpace.getFileName());
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, hashingIndexSpace.getStorageSpaceID());
			setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, hashingIndexSpace.getPageCount());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "HashingIndexSpaceManage.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}