/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.HashingIndexSpace;
import be.WAAR.PresentationLayer.WAARApplicationException;

/**
 * @author Erwin
 *
 */
public abstract class HashingIndexSpaceWebClientFunction extends StorageSpaceWebClientFunction {

	/**
	 * @param sirapriseServer
	 * @param fileName
	 * @param storageSpaceID
	 * @return
	 * @throws NoConnectionException
	 * @throws HashingIndexSpaceNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	HashingIndexSpace getHashingIndexSpace (SiraPriseServer sirapriseServer, String fileName, int storageSpaceID) throws NoConnectionException, HashingIndexSpaceNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(sirapriseServer);
		HashingIndexSpace hashingIndexSpace;
		try {
			AbstractRelation r_hashingIndexSpace = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(JOIN(" + RELVARNAMES.HASHINGINDEXSPACE + "," + RELVARNAMES.STORAGESPACE + "),AND(EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + storageSpaceID + ")),EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + ")))" + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
			if (r_hashingIndexSpace.size() < 1) {
				// filename not found
				throw new HashingIndexSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}
	
			hashingIndexSpace = DBObjectFactory.getObject(r_hashingIndexSpace.iterator().next(), HashingIndexSpace.class);
	
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
		return hashingIndexSpace;
	}


}
