/**
 * 
 */
package be.SIRAPRISE.webclient;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;


/**
 * @author Erwin
 *
 */
abstract class I18N {

	/**
	 * 
	 */
	private static final HashMap<String, ResourceBundle> resourceBundleMap = new HashMap<String, ResourceBundle>();

	/**
	 * @param locale
	 * @param key
	 * @return
	 */
	static String getString (Locale locale, String key) {
		ResourceBundle resourceBundle;
		String language = locale.getLanguage();
		if (resourceBundleMap.containsKey(language)) {
			resourceBundle = resourceBundleMap.get(language);
		} else {
			resourceBundle = ResourceBundle.getBundle(I18N.class.getName(), new Locale(language));
			resourceBundleMap.put(language, resourceBundle);
		}
		
		try {
			return resourceBundle.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	/**
	 * Prevent instantiation
	 */
	private I18N ( ) {

	}
}
