package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.IndexComponent;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to delete indexcomponents
 * 
 * @author Erwin
 */
public class IndexComponentDelete extends IndexComponentWebClientFunction {

	/**
	 * @param sirapriseServer
	 * @param wv_relvarName
	 * @param wv_indexName
	 * @throws WaarException
	 * @throws AttributeOrOrdinalRequiredException
	 */
	private void processSelectedComponent (SiraPriseServer sirapriseServer, GenericStringValue wv_relvarName, GenericStringValue wv_indexName) throws WaarException, AttributeOrOrdinalRequiredException {
		IndexComponent indexComponent;
		GenericStringValue wv_attributeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME);
		if (wv_attributeName != null) {
			indexComponent = getAttributeNameComponent(sirapriseServer, wv_relvarName, wv_indexName, wv_attributeName);
		} else {
			GenericIntegerValue wv_ordinal = (GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.ORDINAL);
			if (wv_ordinal != null) {
				indexComponent = getOrdinalComponent(sirapriseServer, wv_relvarName, wv_indexName, wv_ordinal);
			} else {
				throw new AttributeOrOrdinalRequiredException(getUserLocale());
			}
		}

		setPresentation("IndexComponentDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, indexComponent.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.INDEXNAME, indexComponent.getIndexName());
		setPresentationValue(PRESENTATIONFIELDNAMES.EXPRESSION, indexComponent.getExpression());
		setPresentationValue(ATTRIBUTENAMES.ORDINAL, indexComponent.getOrdinal());

		saveInFunctionContext(RELVARNAMES.INDEXCOMPONENT, indexComponent);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_indexName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.INDEXNAME);
		if (wv_relvarName != null && wv_indexName != null) {
			processSelectedComponent(sirapriseServer, wv_relvarName, wv_indexName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentation().getName().equalsIgnoreCase(INDEXCOMPONENTSELECT)) {
			GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
			GenericStringValue wv_indexName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.INDEXNAME);
			processSelectedComponent(sirapriseServer, wv_relvarName, wv_indexName);
		} else {
			IndexComponent indexComponent = (IndexComponent) getFromFunctionContextMandatory(RELVARNAMES.INDEXCOMPONENT);

			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAssignmentCommand[] { indexComponent.dbDeleteCommand(RELVARNAMES.INDEXCOMPONENT) }); //$NON-NLS-1$
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return INDEXCOMPONENTSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "IndexComponentDelete.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}