/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.IndexComponent;
import be.WAAR.PresentationLayer.GenericIntegerValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.WaarException;

/**
 * @author Erwin
 * 
 */
public abstract class IndexComponentWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String INDEXCOMPONENTSELECT = "IndexComponentSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @param wv_attributeName
	 * @param wv_indexName
	 * @param wv_relvarName
	 * @return
	 * @throws WaarException
	 */
	IndexComponent getAttributeNameComponent (SiraPriseServer sirapriseServer, GenericStringValue wv_relvarName, GenericStringValue wv_indexName, GenericStringValue wv_attributeName) throws WaarException {
		String indexName = wv_indexName.getString().trim();
		String attributeName = wv_attributeName.getString().trim();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation tuples = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + ",AND(EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + indexName + ")),AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + wv_relvarName.getString().trim() + ")),EQ(" + PRESENTATIONFIELDNAMES.EXPRESSION + ",STRING(" + attributeName + ")))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
			if (tuples.size() < 1) {
				throw new NoSuchIndexComponentException(attributeName, indexName, getUserLocale());
			}
			return tuples.toObjectCollection(IndexComponent.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/**
	 * @param sirapriseServer
	 * @param wv_ordinal
	 * @param wv_indexName
	 * @param wv_relvarName
	 * @return
	 * @throws WaarException
	 */
	IndexComponent getOrdinalComponent (SiraPriseServer sirapriseServer, GenericStringValue wv_relvarName, GenericStringValue wv_indexName, GenericIntegerValue wv_ordinal) throws WaarException {
		String indexName = wv_indexName.getString().trim();
		int ordinal = wv_ordinal.getInteger();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			AbstractRelation tuples = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + ",AND(EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + indexName + ")),AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + wv_relvarName.getString().trim() + ")),EQ(" + ATTRIBUTENAMES.ORDINAL + ",INT(" + ordinal + ")))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			if (tuples.size() < 1) {
				throw new NoSuchIndexComponentException(ordinal, indexName, getUserLocale());
			}
			return tuples.toObjectCollection(IndexComponent.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

}
