package be.SIRAPRISE.webclient;

import java.util.Arrays;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Index;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to delete an index. If the index happens to be a tupleindex, then the tupleindex tuple is also deleted.
 * 
 * @author Erwin
 */
public class IndexDelete extends IndexWebClientFunction {

	/**
	 * Leave the function after exit or not
	 */
	boolean leave = false;

	/**
	 * @throws WaarException
	 * @throws NameOrFileRequiredException
	 */
	private void processIndexSelect ( ) throws WaarException, NameOrFileRequiredException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		AbstractRelation rsp = getMatchingIndexesRelation(sirapriseServer);

		if (rsp.size() == 1) {
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				Index index = rsp.toObjectCollectionIgnoringMissingSetters(Index.class).iterator().next();
				setPresentation("IndexDeleteConfirm"); //$NON-NLS-1$
				setSiraPriseServerPortPresentationValues(sirapriseServer);
				String relvarName = index.getRelvarName();
				setPresentationValue(ATTRIBUTENAMES.RELVARNAME, relvarName);
				String indexName = index.getName();
				setPresentationValue(ATTRIBUTENAMES.INDEXNAME, indexName);
				setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, index.getRecordTypeName());
				setPresentationValue(ATTRIBUTENAMES.FILENAME, index.getFileName());
				setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, index.getStorageSpaceID());
				setPresentationValue("INDEXTYPE", rsp.iterator().next().value("INDEXTYPE")); //$NON-NLS-1$ //$NON-NLS-2$

				setPresentationValue("COMPONENTLIST", getWAARListValue("COMPONENTLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + ",AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + indexName + ")))),(" + ATTRIBUTENAMES.ORDINAL + ")"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$

				saveInFunctionContext(RELVARNAMES.INDEX, index);
			} catch (ConstructorMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		setPresentationValue("FUNCTION", new GenericStringValue("Delete")); //$NON-NLS-1$//$NON-NLS-2$
		processIndexSelect();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentation().getName().equalsIgnoreCase(INDEXSELECT)) {
			processIndexSelect();
		} else {
			Index index = (Index) getFromFunctionContextMandatory(RELVARNAMES.INDEX);
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				String relvarName = index.getRelvarName();
				String indexName = index.getName();
				// Remove the attribute value distribution statistics for all those attributes that are a component solely in the deleted index on the relvar
				String cmd3 = "UNASSERT " + RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION + ",SEMIMINUS(RESTRICT(" + RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))),PROJECT(RESTRICT(" + RELVARNAMES.INDEXATTRIBUTE + ",AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),NOT(EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + indexName + "))))),(" + ATTRIBUTENAMES.RELVARNAME + "," + "ATTRIBUTENAME" + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
				String cmd4 = "DELETE " + RELVARNAMES.INDEXCOMPONENT + ",RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + ",AND(EQ(NAME(" + indexName + ")," + ATTRIBUTENAMES.INDEXNAME + "),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(Arrays.asList(new Object[] { index.dbDeleteCommand(RELVARNAMES.INDEX), index.dbUnAssertCommand(RELVARNAMES.TUPLEINDEX), cmd3, cmd4 })); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return INDEXSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "IndexDelete.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}