package be.SIRAPRISE.webclient;

import java.util.Arrays;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Index;
import be.WAAR.PresentationLayer.*;
import be.erwinsmout.MyMessageFormat;

/**
 * Function to Manage the details of an index definition
 * 
 * @author Erwin
 */
public class IndexManage extends IndexWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processIndexSelect ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		AbstractRelation rsp = getMatchingIndexesRelation(sirapriseServer);

		if (rsp.size() == 1) {
			try {
				Index index = rsp.toObjectCollectionIgnoringMissingSetters(Index.class).iterator().next();
				setPresentation("IndexManageDetails"); //$NON-NLS-1$
				setSiraPriseServerPortPresentationValues(sirapriseServer);
				String relvarName = index.getRelvarName();
				String indexName = index.getName();
				setPresentationValue(ATTRIBUTENAMES.RELVARNAME, relvarName);
				setPresentationValue(ATTRIBUTENAMES.INDEXNAME, indexName);
				setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, index.getRecordTypeName());
				setPresentationValue(ATTRIBUTENAMES.FILENAME, index.getFileName());
				setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, index.getStorageSpaceID());
				setPresentationValue("INDEXTYPE", rsp.iterator().next().value("INDEXTYPE")); //$NON-NLS-1$ //$NON-NLS-2$
				setComponentListValue(relvarName, indexName, sirapriseServer);

				saveInFunctionContext(RELVARNAMES.INDEX, index);
			} catch (ConstructorMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			}
		}
	}

	/**
	 * Refreshes the index component list on the window
	 * 
	 * @param relvarName
	 * @param indexName
	 * @param sirapriseServer
	 * @throws WaarException
	 */
	private void setComponentListValue (String relvarName, String indexName, SiraPriseServer sirapriseServer) throws WaarException {
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("COMPONENTLIST", getWAARListValue("COMPONENTLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + ",AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + indexName + ")))),(" + ATTRIBUTENAMES.ORDINAL + ")"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		setPresentationValue("FUNCTION", new GenericStringValue("Manage")); //$NON-NLS-1$//$NON-NLS-2$
		processIndexSelect();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentation().getName().equalsIgnoreCase(INDEXSELECT)) {
			processIndexSelect();
		} else {
			Index index = (Index) getFromFunctionContextMandatory(RELVARNAMES.INDEX);

			String newIndexName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.INDEXNAME)).getString();

			index.setName(newIndexName);
			index.setFileName(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString());
			index.setStorageSpaceID(((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger());

			try {
				String oldIndexName = ((Index) index.getPreUpdateState()).getName();
				LinkedList<Object> updateCmds = new LinkedList<Object>(Arrays.asList(new DmlUpdateCommand[] { index.dbUpdateCommand(RELVARNAMES.INDEX) }));
				if (!index.getName().equals(oldIndexName)) {
					// rename indexname in all all other concerned relvars (INDEXCOMPONENT INDEXATTRIBUTE INDEXID TUPLEINDEX RECORDTYPE)
					String restrictCondition = "AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + index.getRelvarName() + ")),EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + oldIndexName + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					String updateSpec = "(" + ATTRIBUTENAMES.INDEXNAME + "(NAME(" + newIndexName + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					updateCmds.addLast("UPDATE " + RELVARNAMES.INDEXID + ",RESTRICT(" + RELVARNAMES.INDEXID + "," + restrictCondition + ")," + updateSpec); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
					updateCmds.addLast("UPDATE " + RELVARNAMES.INDEXCOMPONENT + ",RESTRICT(" + RELVARNAMES.INDEXCOMPONENT + "," + restrictCondition + ")," + updateSpec); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					updateCmds.addLast("UPDATE " + RELVARNAMES.INDEXATTRIBUTE + ",RESTRICT(" + RELVARNAMES.INDEXATTRIBUTE + "," + restrictCondition + ")," + updateSpec); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					updateCmds.addLast("UPDATE " + RELVARNAMES.TUPLEINDEX + ",RESTRICT(" + RELVARNAMES.TUPLEINDEX + "," + restrictCondition + ")," + updateSpec); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					updateCmds.addLast("UPDATE " + RELVARNAMES.RECORDTYPE + ",RESTRICT(" + RELVARNAMES.RECORDTYPE + "," + restrictCondition + ")," + updateSpec); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(updateCmds); //$NON-NLS-1$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}

				setComponentListValue(index.getRelvarName(), newIndexName, sirapriseServer);
			} catch (NoUpdatesException e1) {

			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		Index index = (Index) getFromFunctionContextMandatory(RELVARNAMES.INDEX);
		setComponentListValue(index.getRelvarName(), index.getName(), setSiraPriseServerPortPresentationValues());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return INDEXSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return MyMessageFormat.format(I18N.getString(getUserLocale(), "IndexManage.Text"), new String[] {}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}