package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to display an overview of known indexes.
 * 
 * @author Erwin
 */
public class IndexOverview extends IndexWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null || getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null) {
			doPresentationLogic();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_fileName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME);
		GenericIntegerValue wv_indexSpaceID = (GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID);

		String restrictExpressionOnIndexRelvar;
		String restrictCondition = ""; //$NON-NLS-1$
		if (wv_fileName != null) {
			restrictCondition = "EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + wv_fileName.getString().trim() + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (wv_indexSpaceID != null) {
				restrictCondition = "AND(" + restrictCondition + ",EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + wv_indexSpaceID.getInteger() + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
		} else {
			if (wv_indexSpaceID != null) {
				throw new StorageSpaceWithoutFileNameException(getUserLocale());
			}
		}

		if (wv_relvarName != null) {
			String relvarName = wv_relvarName.getString();
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			} else {
				restrictCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			}
		}

		if (restrictCondition.length() > 0) {
			restrictExpressionOnIndexRelvar = "RESTRICT(" + RELVARNAMES.INDEX + "," + restrictCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} else {
			restrictExpressionOnIndexRelvar = RELVARNAMES.INDEX;
		}

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue(
					"INDEXLIST", getWAARListValue("INDEXLIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("UNION(EXTEND(JOIN(" + restrictExpressionOnIndexRelvar + "," + RELVARNAMES.TUPLEINDEX + "),(INDEXTYPE(STRING(TUPLEINDEX)))),JOIN(SEMIMINUS(" + restrictExpressionOnIndexRelvar + "," + RELVARNAMES.TUPLEINDEX + "),UNION(EXTEND(UNION(" + RELVARNAMES.HASHINGINDEXSPACE + ",PROJECT(" + RELVARNAMES.MULTIHASHINGINDEXSPACE + ",(" + ATTRIBUTENAMES.STORAGESPACEID + "," + ATTRIBUTENAMES.FILENAME + "))),(INDEXTYPE(STRING(HASH)))),EXTEND(" + RELVARNAMES.TREEINDEXSPACE + ",(INDEXTYPE(STRING(TREE)))))))"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "IndexOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}