/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.WAAR.PresentationLayer.GenericIntegerValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.WAARApplicationException;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;

/**
 * @author Erwin
 *
 */
public abstract class IndexWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String INDEXSELECT = "IndexSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws IndexNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws NameOrFileRequiredException
	 */
	final AbstractRelation getMatchingIndexesRelation (SiraPriseServer sirapriseServer) throws WaarException, NoConnectionException, IndexNotFoundException, DBProblem, WAARApplicationException, NameOrFileRequiredException {
		WaarValue wv_indexName = getPresentationValue(ATTRIBUTENAMES.INDEXNAME);
		WaarValue wv_relvarName = getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_fileName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME);
		GenericIntegerValue wv_storageSpaceID = (GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID);
	
		String restrictCondition = ""; //$NON-NLS-1$
		if (wv_indexName != null) {
			restrictCondition = "EQ(" + ATTRIBUTENAMES.INDEXNAME + ",NAME(" + ((GenericStringValue) wv_indexName).getString().trim() + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		if (wv_relvarName != null) {
			String relvarNameCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + ((GenericStringValue) wv_relvarName).getString().trim() + "))";//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			} else {
				restrictCondition = relvarNameCondition;
			}
		}
		if (wv_fileName != null) {
			String fileNameCondition = "EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + wv_fileName.getString().trim() + "))";//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + fileNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			} else {
				restrictCondition = fileNameCondition;
			}
			if (wv_storageSpaceID != null) {
				String storageSpaceIDCondition = "EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + wv_storageSpaceID.getInteger() + "))";//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if (restrictCondition.length() > 0) {
					restrictCondition = "AND(" + restrictCondition + "," + storageSpaceIDCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
				} else {
					restrictCondition = storageSpaceIDCondition;
				}
			}
		}
	
		if (restrictCondition.length() > 0) {
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("JOIN(RESTRICT(" + RELVARNAMES.INDEX + "," + restrictCondition + "),UNION(EXTEND(UNION(" + RELVARNAMES.HASHINGINDEXSPACE + ",PROJECT(" + RELVARNAMES.MULTIHASHINGINDEXSPACE + ",(" + ATTRIBUTENAMES.FILENAME + "," + ATTRIBUTENAMES.STORAGESPACEID + "))),(INDEXTYPE(STRING(HASH)))),EXTEND(" + RELVARNAMES.TREEINDEXSPACE + ",(INDEXTYPE(STRING(TREE))))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
				if (rsp.size() == 0) {
					throw new IndexNotFoundException(getUserLocale());
				}
	
				if (rsp.size() > 0) {
					setPresentationValue("INDEXLIST", getWAARListValue("INDEXLIST", rsp, null)); //$NON-NLS-1$ //$NON-NLS-2$
				}
				return rsp;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		} else {
			throw new NameOrFileRequiredException(getUserLocale());
		}
	}
}
