/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.JavaBackedType;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 *
 */
abstract class JavaTypesWebClientFunction extends TypesWebClientFunction {

	/**
	 * 
	 */
	static final String TYPESSELECT = "TypesSelect"; //$NON-NLS-1$

	/**
	 * @param siraPriseServer
	 * @param typeName
	 * @return
	 * @throws NoConnectionException
	 * @throws UserNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final JavaBackedType getType (SiraPriseServer siraPriseServer, String typeName) throws NoConnectionException, UserNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		DBConnection dbc = getDBConnection(siraPriseServer);
		try {
			AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(" + RELVARNAMES.TYPEPROPERTIES + ",EQ(" + ATTRIBUTENAMES.TYPENAME + ",NAME(" + typeName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			if (rsp.size() < 1) {
				throw new TypeNotFoundException(typeName, getUserLocale());
			}
			return rsp.toObjectCollection(JavaBackedType.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}
}
