package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Key;
import be.SIRAPRISE.client.jsba.KeyAttribute;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin Smout
 */
public class KeyAttributesCreate extends KeyAttributesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				AbstractRelation[] r_otherAtttributes = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY).execQueriesAndEndTransaction(new String[] { "RESTRICT(" + RELVARNAMES.KEY + ",EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + ")))", "MINUS(PROJECT(RESTRICT(JOIN(" + RELVARNAMES.KEY + "," + RELVARNAMES.RELVARATTRIBUTE + "),EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + "))),(" + ATTRIBUTENAMES.ATTRIBUTENAME + ")),PROJECT(RESTRICT(" + RELVARNAMES.KEYATTRIBUTE + ",EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + "))),(" + ATTRIBUTENAMES.ATTRIBUTENAME + ")))" }); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$ //$NON-NLS-15$
				if (r_otherAtttributes[0].size() > 0) {
					setPresentationValue(ATTRIBUTENAMES.RELVARNAME, r_otherAtttributes[0].toObjectCollection(Key.class).iterator().next().getRelvarName());
				}
				setPresentationValue("ATTRIBUTELIST", getWAARListValue("ATTRIBUTELIST", r_otherAtttributes[1], null)); //$NON-NLS-1$ //$NON-NLS-2$

			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} catch (SettersMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ConstructorMissingException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				log(e);
				throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
			} finally {
				dbc.close();
			}

		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			// String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
			long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
			Set<String> attributeNames = RelationValueSelectorFactory.getNames(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString().trim());

			Collection<DmlAddCommand> cmds = new HashSet<DmlAddCommand>();
			for (String attributeName : attributeNames) {
				cmds.add(new KeyAttribute(errorCode, attributeName).dbAddCommand(RELVARNAMES.KEYATTRIBUTE));
			}

			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(cmds); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "KeyAttributesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}