package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.KeyAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin Smout
 */
public class KeyAttributesDelete extends KeyAttributesWebClientFunction {

	/**
	 * leave the function after completion or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedAttributeName ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		KeyAttribute keyAttribute = getKeyAttribute(sirapriseServer);

		setPresentation("KeyAttributesDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(sirapriseServer);
		setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, keyAttribute.getAttributeName());
//		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, keyAttribute.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.ERRORCODE, keyAttribute.getErrorCode());

		saveInFunctionContext(RELVARNAMES.KEYATTRIBUTE, keyAttribute);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null && getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedAttributeName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(KEYATTRIBUTESSELECT)) {
			// filename entered, ask confirmation
			processSelectedAttributeName();
		} else {
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execDmlCommandAndEndTransaction(((KeyAttribute) getFromFunctionContextMandatory(RELVARNAMES.KEYATTRIBUTE)).dbDeleteCommand(RELVARNAMES.KEYATTRIBUTE)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return KEYATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "KeyAttributesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}