/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.KeyAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 * 
 */
public abstract class KeyAttributesWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String KEYATTRIBUTESSELECT = "KeyAttributesSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws KeyAttributeNotFoundException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 * @throws IllDefinedDBInterfaceClassException
	 */
	final KeyAttribute getKeyAttribute (SiraPriseServer sirapriseServer) throws NoConnectionException, KeyAttributeNotFoundException, DBProblem, WAARApplicationException, IllDefinedDBInterfaceClassException {
		long errorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger();
//		String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();
		String attributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(" + RELVARNAMES.KEYATTRIBUTE + ",AND(EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + ")),EQ(" + ATTRIBUTENAMES.ATTRIBUTENAME + ",NAME(" + attributeName + "))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
			if (rsp.size() == 0) {
				throw new KeyAttributeNotFoundException(attributeName, errorCode, getUserLocale());
			}
			return rsp.toObjectCollection(KeyAttribute.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

}
