/*
 * Created on 6-apr-2008
 */
package be.SIRAPRISE.webclient;

import java.util.Locale;

import be.WAAR.PresentationLayer.WAARApplicationException;
import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
class KeyNotFoundException extends WAARApplicationException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2549245065926316574L;

	/**
	 * @param errorCode
	 * @param locale 
	 */
	KeyNotFoundException (long errorCode, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "KeyNotFoundException.Text"), new String[] { Long.toString(errorCode) })); //$NON-NLS-1$
	}

	/**
	 * @param errorCode
	 * @param relvarName 
	 * @param locale 
	 */
	KeyNotFoundException (long errorCode, String relvarName, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "KeyNotFoundException.Text2"), new String[] { Long.toString(errorCode), relvarName })); //$NON-NLS-1$
	}

}
