package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Key;
import be.SIRAPRISE.client.jsba.KeyAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin Smout
 */
public class KeysDelete extends KeysWebClientFunction {

	/**
	 * 
	 */
	private static final String DBOBJECTSTOBEDELETED = "DBOBJECTSTOBEDELETED"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_DELETECONFIRMATION = "KeysDeleteConfirm"; //$NON-NLS-1$

	/**
	 * leave the function after exit or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	@SuppressWarnings("unchecked")
	private void processDeleteConfirmation ( ) throws WaarException, NoConnectionException, DBProblem, WAARApplicationException {
		Map<String, Collection<? extends AbstractUpdatableDBObject>> dbObjectsToBeDeleted = (Map<String, Collection<? extends AbstractUpdatableDBObject>>) getFromFunctionContextMandatory(DBOBJECTSTOBEDELETED);
		Collection<DmlAssignmentCommand> deleteCommands = new HashSet<DmlAssignmentCommand>();
		for (Entry<String, Collection<? extends AbstractUpdatableDBObject>> me : dbObjectsToBeDeleted.entrySet()) {
			String relvarName = me.getKey();
			for (AbstractUpdatableDBObject dbObject : me.getValue()) {
				deleteCommands.add(dbObject.dbDeleteCommand(relvarName));
			}
		}

		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(deleteCommands); //$NON-NLS-1$
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedKey ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		AbstractRelation r_keyData = getKeyData(sirapriseServer, ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE)).getLonginteger(), (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME));
		try {
			Map<String, Collection<AbstractUpdatableDBObject>> dbObjectsToBeDeleted = new HashMap<String, Collection<AbstractUpdatableDBObject>>();
			Collection<Key> keyObjects = r_keyData.toObjectCollectionIgnoringMissingSetters(Key.class);
			Key key = keyObjects.iterator().next();
			dbObjectsToBeDeleted.put(RELVARNAMES.KEY, new HashSet<AbstractUpdatableDBObject>(keyObjects));
			AbstractRelation r_keyAttributes = r_keyData.iterator().next().rvaValue(ATTRIBUTES);
			dbObjectsToBeDeleted.put(RELVARNAMES.KEYATTRIBUTE, new HashSet<AbstractUpdatableDBObject>(r_keyAttributes.toObjectCollection(KeyAttribute.class)));
			saveInFunctionContext(DBOBJECTSTOBEDELETED, dbObjectsToBeDeleted);

			setPresentation(PRESENTATIONNAME_DELETECONFIRMATION);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, key.getRelvarName());
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, key.getErrorCode());
			setPresentationValue("ATTRIBUTELIST", getWAARListValue("ATTRIBUTELIST", r_keyAttributes, null));  //$NON-NLS-1$//$NON-NLS-2$
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedKey();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(KEYSSELECT)) {
			// filename entered, ask confirmation
			processSelectedKey();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return KEYSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "KeysDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}