package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.Key;
import be.SIRAPRISE.client.jsba.KeyAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class KeysManage extends KeysWebClientFunction {

	/**
	 * 
	 */
	private static final String PRESENTATIONNAME_MANAGEDETAILS = "KeysManageDetails"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String DBOBJECTS = "DBOBJECTS"; //$NON-NLS-1$

	/**
	 * @throws WaarException
	 */
	private void processSelectedKey ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericLongValue wv_errorCode = (GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE);
		try {
			AbstractRelation r_key = getKeyData(sirapriseServer, wv_errorCode.getLonginteger(), (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME));
			AbstractRelation r_keyAttributes = r_key.iterator().next().rvaValue(ATTRIBUTES);

			Map<String, Collection<AbstractUpdatableDBObject>> dbObjectsToBeDeleted = new HashMap<String, Collection<AbstractUpdatableDBObject>>();
			final Collection<Key> keysCollection = r_key.toObjectCollectionIgnoringMissingSetters(Key.class);
			dbObjectsToBeDeleted.put(RELVARNAMES.KEY, new HashSet<AbstractUpdatableDBObject>(keysCollection));
			dbObjectsToBeDeleted.put(RELVARNAMES.KEYATTRIBUTE, new HashSet<AbstractUpdatableDBObject>(r_keyAttributes.toObjectCollection(KeyAttribute.class)));
			saveInFunctionContext(DBOBJECTS, dbObjectsToBeDeleted);

			setPresentation(PRESENTATIONNAME_MANAGEDETAILS);
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, keysCollection.iterator().next().getRelvarName());
			setPresentationValue(ATTRIBUTENAMES.ERRORCODE, wv_errorCode);

			setPresentationValue("ATTRIBUTELIST", getWAARListValue("ATTRIBUTELIST", r_keyAttributes, null)); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		}
	}

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	@SuppressWarnings("unchecked")
	private void processUpdateConfirmation ( ) throws WaarException, NoConnectionException, DBProblem, WAARApplicationException {
		// <OK> clicked on managedetails presentation ; try to modify key definition
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		String newRelvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
		GenericLongValue wv_newErrorCode = ((GenericLongValue) getPresentationValue(ATTRIBUTENAMES.ERRORCODE));
		long newErrorCode = wv_newErrorCode.getLonginteger();

		Map<String, Collection<AbstractUpdatableDBObject>> dbObjects = (Map<String, Collection<AbstractUpdatableDBObject>>) getFromFunctionContextMandatory(DBOBJECTS);
		Key key = (Key) dbObjects.get(RELVARNAMES.KEY).iterator().next();

		key.setErrorCode(newErrorCode);
		key.setRelvarName(newRelvarName);
		Collection<DmlAssignmentCommand> commands = new HashSet<DmlAssignmentCommand>();
		try {
			commands.add(key.dbUpdateCommand(RELVARNAMES.KEY));
			for (AbstractUpdatableDBObject keyAttribute : dbObjects.get(RELVARNAMES.KEYATTRIBUTE)) {
				((KeyAttribute) keyAttribute).setErrorCode(newErrorCode);
//				keyAttribute.setRelvarName(newRelvarName);
				try {
					commands.add(keyAttribute.dbUpdateCommand(RELVARNAMES.KEYATTRIBUTE));
				} catch (NoUpdatesException e1) {

				}
			}
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatement(commands); //$NON-NLS-1$
				key.setPreUpdateState();
				for (AbstractUpdatableDBObject keyAttribute : dbObjects.get(RELVARNAMES.KEYATTRIBUTE)) {
					keyAttribute.setPreUpdateState();
				}

			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		} catch (NoUpdatesException e1) {

		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.ERRORCODE) != null) {
			processSelectedKey();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(KEYSSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedKey();
		} else {
			processUpdateConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		processSelectedKey(); // should work even if the presentation is already the "manage details" screen and not the selection
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return KEYSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "KeysManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}