/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 * 
 */
public abstract class KeysWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String KEYSSELECT = "KeysSelect"; //$NON-NLS-1$

	/**
	 * 
	 */
	static final String ATTRIBUTES = "ATTRIBUTES"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @param errorCode 
	 * @param wv_relvarName 
	 * @return
	 * @throws WAARApplicationException
	 */
	final AbstractRelation getKeyData (SiraPriseServer sirapriseServer, long errorCode, GenericStringValue wv_relvarName) throws WAARApplicationException {
		AbstractRelation r_key;

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, true, TransactionMode.READONLY); //$NON-NLS-1$
			String errorCodeRestrictCondition = "EQ(" + ATTRIBUTENAMES.ERRORCODE + ",LONG(" + errorCode + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			String keyRelvarRestrictCondition;
			if (wv_relvarName != null) {
				keyRelvarRestrictCondition = "AND(" + errorCodeRestrictCondition + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + wv_relvarName.getString().trim() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$
			} else {
				keyRelvarRestrictCondition = errorCodeRestrictCondition;
			}
			r_key = startTransaction.execQueryAndEndTransaction("EXTEND(RESTRICT(" + RELVARNAMES.KEY + "," + keyRelvarRestrictCondition + "),ATTRIBUTES(RESTRICT(" + RELVARNAMES.KEYATTRIBUTE + "," + errorCodeRestrictCondition + ")))"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			if (r_key.size() == 0) {
				throw new KeyNotFoundException(errorCode, getUserLocale());
			}

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}

		return r_key;
	}

}
