/*
 * Created on 11-sep-2007
 */
package be.SIRAPRISE.webclient;

import java.util.Locale;

import be.WAAR.PresentationLayer.WAARApplicationException;
import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
class LogicalLengthNotAllowedForFixedLengthTypesException extends WAARApplicationException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7389745263491607222L;

	/**
	 * Creates the exception object
	 * 
	 * @param typeName
	 *            The name of a fixed-length type, an attribute of which a logical length was specified for
	 * @param locale
	 */
	LogicalLengthNotAllowedForFixedLengthTypesException (String typeName, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "LogicalLengthNotAllowedForFixedLengthTypesException.Text"), new String[] { typeName })); //$NON-NLS-1$
	}
}
