package be.SIRAPRISE.webclient;

import java.io.IOException;
import java.util.Properties;

import be.SIRAPRISE.client.*;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class Main extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	private static final String MAIN_SELECT_SESSION_SERVER = "MainSelectSessionServer"; //$NON-NLS-1$

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		Properties dbConnectionProperties = DBConnectionProperties.getInstance();
		String host = dbConnectionProperties.getProperty(DBConnectionProperties.HOST);
		if (host != null) {
			setPresentationValue(SiraPriseWebClientFunction.SERVER, host);
		}
		String port = dbConnectionProperties.getProperty(DBConnectionProperties.PORT);
		if (port != null) {
			setPresentationValue(DBConnectionProperties.PORT, port);
		}
		String monitorport = dbConnectionProperties.getProperty(DBConnectionProperties.MONITORPORT);
		if (monitorport != null) {
			setPresentationValue(DBConnectionProperties.MONITORPORT, monitorport);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(MAIN_SELECT_SESSION_SERVER)) {
			String server = ((GenericStringValue) getPresentationValue(SiraPriseWebClientFunction.SERVER)).getString().trim();
			int port = ((GenericIntegerValue) getPresentationValue(DBConnectionProperties.PORT)).getInteger();
			int monitorPort = ((GenericIntegerValue) getPresentationValue(DBConnectionProperties.MONITORPORT)).getInteger();
			boolean captureDDL = ((LogicalValue) getPresentationValue("CAPTUREDDL")).getValue(); //$NON-NLS-1$
			try {
				getDBConnection(server, port, getUserLocale()).close();
				new MonitorConnection(server, monitorPort).end();
			} catch (IOException e) {
				throw new NoConnectionException(e, getUserLocale());
			} catch (DBException e) {
				// There has been an error, but the server could be reached and communication with it has most likely been successful. One possible reason for the exception is that the server's maximum number of allowed connections was already used. But we're only interested in knowing whether there really is a server on the indicated address.
			} catch (CommunicationProtocolException e) {
				// A Communication protocol exception is a bit ambiguous, but at its very least it indicates that it is the handshake that has failed, meaning that a Socket connection could successfully be established. So we let this one pass too.
				// throw new NoConnectionException(e);
			}
			saveInSessionContext(SiraPriseWebClientFunction.SIRAPRISESERVER, new SiraPriseServer(server, port, monitorPort, captureDDL));
			setPresentation("MainServerMenu"); //$NON-NLS-1$
			setPresentationValue(SiraPriseWebClientFunction.SERVER, server);
			setPresentationValue(DBConnectionProperties.PORT, port);
			setPresentationValue(DBConnectionProperties.MONITORPORT, monitorPort);
			setPresentationValue("CAPTUREDDL", captureDDL ? I18N.getString(getUserLocale(), "SelectSessionServer.DDLBeingCaptured") : ""); //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
			// } else {
			// WaarValue wv_server = (WaarValue) getFromSessionContext(SiraPriseWebClientFunction.SERVER);
			// GenericIntegerValue wv_port = (GenericIntegerValue) getFromSessionContext(DBConnectionProperties.PORT);
			// GenericIntegerValue wv_monitorPort = (GenericIntegerValue) getFromSessionContext(DBConnectionProperties.MONITORPORT);
			// setPresentationValue(SiraPriseWebClientFunction.SERVER, wv_server);
			// setPresentationValue(DBConnectionProperties.PORT, wv_port);
			// setPresentationValue(DBConnectionProperties.MONITORPORT, wv_monitorPort);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return MAIN_SELECT_SESSION_SERVER;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "SelectSessionServer.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}