package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.MultiHashingIndexSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a new multiple hashing index space in a dbms file
 * 
 * @author Erwin
 */
public class MultiHashingIndexSpaceCreate extends MultiHashingIndexSpaceWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		MultiHashingIndexSpace multiHashingIndexSpace = new MultiHashingIndexSpace(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.PAGECOUNT)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS)).getInteger(), ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT)).getInteger());
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAddCommand[] { new DmlAddCommand(RELVARNAMES.STORAGESPACE, multiHashingIndexSpace), new DmlAddCommand(RELVARNAMES.MULTIHASHINGINDEXSPACE, multiHashingIndexSpace) }); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "MultiHashingIndexSpaceCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}