package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.MultiHashingIndexSpace;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a multiple hashing index space from a dbms file
 * 
 * @author Erwin
 */
public class MultiHashingIndexSpaceDelete extends MultiHashingIndexSpaceWebClientFunction {

	/**
	 * @throws WaarException
	 */
	private void processSelectedMultiHashingIndexSpace ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_fileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME));
		String fileName = wv_fileName.getString().trim();
		GenericIntegerValue wv_storageSpaceID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID));
		int storageSpaceID = wv_storageSpaceID.getInteger();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation r_multiHashingIndexSpace = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(UNION(EXTEND(SEMIMINUS(JOIN(MULTIHASHINGINDEXSPACE,STORAGESPACE),STORAGESPACEEXTENTS),EXTENTSCOUNT(INT(0))),JOIN(MULTIHASHINGINDEXSPACE,STORAGESPACE,STORAGESPACEEXTENTS)),AND(EQ(STORAGESPACEID,INT(" + storageSpaceID + ")),EQ(FILENAME,FILENAME(" + fileName + "))))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if (r_multiHashingIndexSpace.size() < 1) {
				// filename not found
				throw new MultiHashingIndexSpaceNotFoundException(fileName, storageSpaceID, getUserLocale());
			}

			setPresentation("MultiHashingIndexSpaceConfirmDelete"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);

			setPresentationValue(ATTRIBUTENAMES.FILENAME, wv_fileName);
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, wv_storageSpaceID);

			MultiHashingIndexSpace multiHashingIndexSpace = DBObjectFactory.getObject(r_multiHashingIndexSpace.iterator().next(), MultiHashingIndexSpace.class);

			setPresentationValue(ATTRIBUTENAMES.GAPCOMPRESSIONTHRESHOLD, multiHashingIndexSpace.getGapCompressionThreshold());
			setPresentationValue(ATTRIBUTENAMES.MAXIMUMGAPS, multiHashingIndexSpace.getMaximumGaps());
			setPresentationValue(ATTRIBUTENAMES.PAGECOUNT, multiHashingIndexSpace.getPageCount());
			setPresentationValue(ATTRIBUTENAMES.EXTENTSCOUNT, multiHashingIndexSpace.getExtentsCount());

			saveInFunctionContext(RELVARNAMES.MULTIHASHINGINDEXSPACE, multiHashingIndexSpace);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.FILENAME) != null && getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID) != null) {
			processSelectedMultiHashingIndexSpace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(STORAGESPACESELECT)) {
			// errorcode entered, ask confirmation
			processSelectedMultiHashingIndexSpace();
		} else {
			processDeleteConfirmation();
		}
	}

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	private void processDeleteConfirmation ( ) throws WaarException, NoConnectionException, DBProblem, WAARApplicationException {
		MultiHashingIndexSpace multiHashingIndexSpace = (MultiHashingIndexSpace) getFromFunctionContextMandatory(RELVARNAMES.MULTIHASHINGINDEXSPACE);
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlDeleteCommand[] { new DmlDeleteCommand(RELVARNAMES.STORAGESPACE, multiHashingIndexSpace), new DmlDeleteCommand(RELVARNAMES.MULTIHASHINGINDEXSPACE, multiHashingIndexSpace) }); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return STORAGESPACESELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "MultiHashingIndexSpaceDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}