package be.SIRAPRISE.webclient;

import java.util.LinkedList;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to add an attribute to a record type for a relvar.
 * 
 * @author Erwin
 */
public class RecordAttributesCreate extends RecordAttributesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim();
			String recordTypeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME)).getString().trim();
			LinkedList<String> attributeNames = RelationValueSelectorFactory.getNamesInEntryOrder(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString().trim());
			GenericIntegerValue wv_ordinal = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.ORDINAL));
			int ordinal;
			if (wv_ordinal != null) {
				ordinal = wv_ordinal.getInteger();
			} else {
				ordinal = 10 + Math.max(0, Integer.parseInt(((AbstractTuple) startTransaction.execQuery("AGGREGATE (RESTRICT(" + RELVARNAMES.RECORDATTRIBUTE + ",AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + ")))),MAXORD(MAX(" + ATTRIBUTENAMES.ORDINAL + ")))").iterator().next()).value("MAXORD"))); //cater for -2147...... as maximum //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			}

			String tupleList = ""; //$NON-NLS-1$
			for (String attributeName : attributeNames) {
				tupleList += "TUPLE(" + ATTRIBUTENAMES.ORDINAL + "(" + ordinal + ")" + ATTRIBUTENAMES.RELVARNAME + "(" + relvarName + ")" + ATTRIBUTENAMES.ATTRIBUTENAME + "(" + attributeName + ")" + ATTRIBUTENAMES.RECORDTYPENAME + "(" + recordTypeName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
				ordinal += 10;
			}

			String a_recordType = "ADD " + RELVARNAMES.RECORDATTRIBUTE + "," + RELVARNAMES.RECORDATTRIBUTE + "(" + tupleList + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			startTransaction.execMultipleStatementAndEndTransaction(new String[] { a_recordType });

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordAttributesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}