package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to remove an attribute from a record
 * 
 * @author Erwin
 */
public class RecordAttributesDelete extends RecordAttributesWebClientFunction {

	/**
	 * Indicator telling whether the function can be left or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedAttribute ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		String relvarName = wv_relvarName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, relvarName);
		GenericStringValue wv_recordTypeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
		String recordTypeName = wv_recordTypeName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.RECORDTYPENAME, recordTypeName);
		GenericStringValue wv_attributeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME);
		String attributeName = wv_attributeName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.ATTRIBUTENAME, attributeName);

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			AbstractRelation tuples = startTransaction.execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.RECORDATTRIBUTE + ",AND(EQ(" + ATTRIBUTENAMES.ATTRIBUTENAME + ",NAME(" + attributeName + ")),AND(EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + ")),EQ(" + ATTRIBUTENAMES.RELVARNAME+",NAME(" + relvarName + ")))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			if (tuples.size() < 1) {
				throw new NoSuchRecordAttributeException(relvarName, recordTypeName, attributeName, getUserLocale());
			}
			setPresentation("RecordAttributesDeleteConfirm"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, wv_recordTypeName);
			setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, wv_attributeName);

			AbstractTuple tuple = (AbstractTuple) tuples.iterator().next();
			WaarValue wv_ordinal = new GenericIntegerValue(Integer.parseInt(tuple.value(ATTRIBUTENAMES.ORDINAL)));
			saveInFunctionContext(ATTRIBUTENAMES.ORDINAL, wv_ordinal);
			setPresentationValue(ATTRIBUTENAMES.ORDINAL, wv_ordinal);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME) != null && getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null) {
			processSelectedAttribute();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RECORDATTRIBUTESSELECT)) {
			processSelectedAttribute();
		} else {
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { ("DELETE " + RELVARNAMES.RECORDATTRIBUTE + "," + RELVARNAMES.RECORDATTRIBUTE + "(TUPLE(" + ATTRIBUTENAMES.RELVARNAME + "(" + ((String) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME)) + ")" + ATTRIBUTENAMES.RECORDTYPENAME + "(" + ((String) getFromFunctionContextMandatory(ATTRIBUTENAMES.RECORDTYPENAME)) + ")" + ATTRIBUTENAMES.ORDINAL + "(" + ((GenericIntegerValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.ORDINAL)).getInteger() + ")" + ATTRIBUTENAMES.ATTRIBUTENAME + "(" + ((String) getFromFunctionContextMandatory(ATTRIBUTENAMES.ATTRIBUTENAME)) + ")))") }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RECORDATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordAttributesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}