package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.WAAR.PresentationLayer.*;

/**
 * Function to add an attribute to a record type for a relvar.
 * 
 * @author Erwin
 */
public class RecordAttributesManage extends RecordAttributesWebClientFunction {

	/**
	 * @param server
	 * @param port
	 * @throws WaarException 
	 */
	private void processManageDetailsPresentation(String server, int port) throws WaarException {
		GenericStringValue wv_relvarName = ((GenericStringValue)getPresentationValue("NEWRELVARNAME")); //$NON-NLS-1$
		String newrelvarName = wv_relvarName.getString().trim();
		String oldrelvarName = (String)getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_recordTypeName = ((GenericStringValue)getPresentationValue("NEWRECORDTYPENAME")); //$NON-NLS-1$
		String newrecordTypeName = wv_recordTypeName.getString().trim();
		String oldrecordTypeName = (String)getFromFunctionContextMandatory(ATTRIBUTENAMES.RECORDTYPENAME);
		GenericStringValue wv_attributeName = ((GenericStringValue)getPresentationValue("NEWATTRIBUTENAME")); //$NON-NLS-1$
		String newattributeName = wv_attributeName.getString().trim();
		String oldattributeName = (String)getFromFunctionContextMandatory(ATTRIBUTENAMES.ATTRIBUTENAME);
		GenericIntegerValue wv_ordinal = ((GenericIntegerValue)getPresentationValue("NEWORDINAL")); //$NON-NLS-1$
		int newordinal = wv_ordinal.getInteger();
		int oldordinal = ((GenericIntegerValue)getFromFunctionContextMandatory(ATTRIBUTENAMES.ORDINAL)).getInteger();

		String scalarUpdateList = ""; //$NON-NLS-1$
		if (!newrelvarName.equalsIgnoreCase(oldrelvarName)) {
			scalarUpdateList = "RELVARNAME(NAME(" + newrelvarName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (!newrecordTypeName.equalsIgnoreCase(oldrecordTypeName)) {
			scalarUpdateList += "RECORDTYPENAME(NAME(" + newrecordTypeName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (!newattributeName.equalsIgnoreCase(oldattributeName)) {
			scalarUpdateList += "ATTRIBUTENAME(NAME(" + newattributeName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (newordinal != oldordinal) {
			scalarUpdateList += "ORDINAL(INT(" + newordinal + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		String u_recordAttribute = "UPDATE RECORDATTRIBUTE,RECORDATTRIBUTE(TUPLE(ORDINAL(" + oldordinal + ")RELVARNAME(" + oldrelvarName + ")ATTRIBUTENAME(" + oldattributeName + ")RECORDTYPENAME(" + oldrecordTypeName + "))),(" + scalarUpdateList + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$

		DBConnection dbc = getDBConnection(server, port, getUserLocale());
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			startTransaction.execMultipleStatementAndEndTransaction(new String[] { u_recordAttribute });
			saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, newrelvarName);
			saveInFunctionContext(ATTRIBUTENAMES.RECORDTYPENAME, newrecordTypeName);
			saveInFunctionContext(ATTRIBUTENAMES.ATTRIBUTENAME, newattributeName);
			saveInFunctionContext(ATTRIBUTENAMES.ORDINAL, wv_ordinal);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectedAttribute() throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		
		GenericStringValue wv_relvarName = (GenericStringValue)getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		String relvarName = wv_relvarName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, relvarName);
		GenericStringValue wv_recordTypeName = (GenericStringValue)getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
		String recordTypeName = wv_recordTypeName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.RECORDTYPENAME, recordTypeName);
		GenericStringValue wv_attributeName = (GenericStringValue)getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME);
		String attributeName = wv_attributeName.getString().trim();
		saveInFunctionContext(ATTRIBUTENAMES.ATTRIBUTENAME, attributeName);

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation tuples = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(RECORDATTRIBUTE,AND(EQ(ATTRIBUTENAME,NAME(" + attributeName + ")),AND(EQ(RECORDTYPENAME,NAME(" + recordTypeName + ")),EQ(RELVARNAME,NAME(" + relvarName + ")))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			if (tuples.size() < 1) {
				throw new NoSuchRecordAttributeException(relvarName, recordTypeName, attributeName, getUserLocale());
			}
			setPresentation("RecordAttributesManageDetails"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue("NEWRELVARNAME", wv_relvarName); //$NON-NLS-1$
			setPresentationValue("NEWRECORDTYPENAME", wv_recordTypeName); //$NON-NLS-1$
			setPresentationValue("NEWATTRIBUTENAME", wv_attributeName); //$NON-NLS-1$

			AbstractTuple tuple = (AbstractTuple)tuples.iterator().next();
			WaarValue wv_ordinal = new GenericIntegerValue(Integer.parseInt(tuple.value(ATTRIBUTENAMES.ORDINAL)));
			saveInFunctionContext(ATTRIBUTENAMES.ORDINAL, wv_ordinal);
			setPresentationValue("NEWORDINAL", wv_ordinal); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic() throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME) != null && getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null) {
			processSelectedAttribute();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic() throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		
		if (getPresentation().getName().equalsIgnoreCase(RECORDATTRIBUTESSELECT)) {
			processSelectedAttribute();
		} else {
			processManageDetailsPresentation(sirapriseServer.getServer(), sirapriseServer.getPort());
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName() {
		return RECORDATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription(String language) {
		return I18N.getString(getUserLocale(), "RecordAttributesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit() {
		return false;
	}
}