package be.SIRAPRISE.webclient;

import java.util.LinkedList;
import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.WAAR.PresentationLayer.*;

/**
 * Function to define a new record type for a relvar.
 * 
 * @author Erwin
 */
public class RecordTypesCreate extends RecordTypesWebClientFunction {

	/**
	 * Leave the function after completion or not
	 */
	boolean leave = false;

	/**
	 * Processes the "Prompt tuple index details for existing record type" screen
	 * 
	 * @throws WaarException
	 */
	@SuppressWarnings("unchecked")
	private void processPromptTupleIndexForExistingRecordType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		String tupleIndexName = ((GenericStringValue) getPresentationValue("TUPLEINDEXNAME")).getString().trim(); //$NON-NLS-1$
		String relvarName = (String) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME);
		String recordTypeName = (String) getFromFunctionContextMandatory("EXISTINGRECORDTYPENAME"); //$NON-NLS-1$
		LinkedList<String> commandList = (LinkedList<String>) getFromFunctionContextMandatory("COMMANDLIST"); //$NON-NLS-1$
		commandList.addLast("ADD TUPLEINDEX,TUPLEINDEX(TUPLE(INDEXNAME(" + tupleIndexName + ")RELVARNAME(" + relvarName + ")RECORDTYPENAME(" + recordTypeName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		commandList.addLast("ADD INDEX,INDEX(TUPLE(INDEXNAME(" + tupleIndexName + ")RELVARNAME(" + relvarName + ")RECORDTYPENAME(" + recordTypeName + ")STORAGESPACEID(" + ((GenericIntegerValue) getPresentationValue("TUPLEINDEXSTORAGESPACEID")).getInteger() + ")FILENAME(" + ((GenericStringValue) getPresentationValue("TUPLEINDEXFILENAME")).getString().trim() + ")))"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(commandList); //$NON-NLS-1$
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			popoffPresentation();
			dbc.close();
		}
	}

	/**
	 * Processes the main screen.
	 * 
	 * @throws WaarException
	 * @throws TupleIndexNotCompletelySpecifiedException
	 * @throws TupleIndexRequiredException
	 * @throws ExpectedBracketsMissingException
	 * @throws DBProblem
	 * @throws NoConnectionException
	 */
	private void processRecordTypesCreate ( ) throws WaarException, TupleIndexNotCompletelySpecifiedException, TupleIndexRequiredException, ExpectedBracketsMissingException, DBProblem, NoConnectionException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			GenericStringValue wv_relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME));
			String relvarName = wv_relvarName.getString().trim();
			String recordTypeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME)).getString().trim();
			String dataSpaceFileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME)).getString().trim();
			int DATASPACE_STORAGESPACEID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID)).getInteger();
			String indexName = ((GenericStringValue) getPresentationValue("LOCATORINDEXNAME")).getString().trim(); //$NON-NLS-1$
			String indexSpaceFileName = ((GenericStringValue) getPresentationValue("LOCATORINDEXFILENAME")).getString().trim(); //$NON-NLS-1$
			int indexSpaceStorageSpaceID = ((GenericIntegerValue) getPresentationValue("LOCATORINDEXSTORAGESPACEID")).getInteger(); //$NON-NLS-1$
			GenericStringValue wv_indexAttributeList = ((GenericStringValue) getPresentationValue("LOCATORINDEXATTRIBUTES")); //$NON-NLS-1$
			GenericStringValue wv_recordAttributeList = ((GenericStringValue) getPresentationValue("RECORDATTRIBUTES")); //$NON-NLS-1$

			LinkedList<String> commandList = new LinkedList<String>();
			commandList.addLast("ADD RECORDTYPE,RECORDTYPE(TUPLE(STORAGESPACEID(" + DATASPACE_STORAGESPACEID + ")RELVARNAME(" + relvarName + ")FILENAME(" + dataSpaceFileName + ")RECORDTYPENAME(" + recordTypeName + ")INDEXNAME(" + indexName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			commandList.addLast("ADD INDEX,INDEX(TUPLE(INDEXNAME(" + indexName + ")STORAGESPACEID(" + indexSpaceStorageSpaceID + ")RELVARNAME(" + relvarName + ")FILENAME(" + indexSpaceFileName + ")RECORDTYPENAME(" + recordTypeName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$

			GenericStringValue wv_tupleIndexName = ((GenericStringValue) getPresentationValue("TUPLEINDEXNAME")); //$NON-NLS-1$
			GenericStringValue wv_tupleIndexSpaceFileName = ((GenericStringValue) getPresentationValue("TUPLEINDEXFILENAME")); //$NON-NLS-1$
			GenericIntegerValue wv_tupleIndexSpaceStorageSpaceID = ((GenericIntegerValue) getPresentationValue("TUPLEINDEXSTORAGESPACEID")); //$NON-NLS-1$

			if (wv_tupleIndexName == null) {
				if (wv_tupleIndexSpaceFileName != null || wv_tupleIndexSpaceStorageSpaceID != null) {
					throw new TupleIndexNotCompletelySpecifiedException(getUserLocale());
				}
			} else {
				if (wv_tupleIndexSpaceFileName == null || wv_tupleIndexSpaceStorageSpaceID == null) {
					throw new TupleIndexNotCompletelySpecifiedException(getUserLocale());
				} else {
					String tupleIndexName = wv_tupleIndexName.getString().trim();
					commandList.addLast("ADD TUPLEINDEX,TUPLEINDEX(TUPLE(INDEXNAME(" + tupleIndexName + ")RELVARNAME(" + relvarName + ")RECORDTYPENAME(" + recordTypeName + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					commandList.addLast("ADD INDEX,INDEX(TUPLE(INDEXNAME(" + tupleIndexName + ")RELVARNAME(" + relvarName + ")RECORDTYPENAME(" + recordTypeName + ")STORAGESPACEID(" + wv_tupleIndexSpaceStorageSpaceID.getInteger() + ")FILENAME(" + wv_tupleIndexSpaceFileName.getString().trim() + ")))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
				}
			}

			// If locator index attributes specified, add those to the command list as well
			if (wv_indexAttributeList != null) {
				String indexAttributeList = wv_indexAttributeList.getString().trim();
				String indexComponentsCommand = ""; //$NON-NLS-1$
				int ordinal = 0;
				while (indexAttributeList.length() > 0) {
					int cp = indexAttributeList.indexOf(',');
					String indexAttributeName;
					if (cp < 0) {
						indexAttributeName = indexAttributeList.trim();
						indexAttributeList = ""; //$NON-NLS-1$
					} else {
						indexAttributeName = indexAttributeList.substring(0, cp).trim();
						indexAttributeList = indexAttributeList.substring(cp + 1).trim();
					}
					indexComponentsCommand += "TUPLE(INDEXNAME(" + indexName + ")ORDINAL(" + (ordinal += 10) + ")RELVARNAME(" + relvarName + ")sp_expression(" + indexAttributeName + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$
				}
				if (indexComponentsCommand.length() > 0) {
					indexComponentsCommand = "ADD INDEXCOMPONENT,INDEXCOMPONENT(" + indexComponentsCommand + ")"; //$NON-NLS-1$ //$NON-NLS-2$
					commandList.addLast(indexComponentsCommand);
				}
			}

			// Add recordattributes only if they are specified
			// If record attributes specified, add those to the command list as well
			if (wv_recordAttributeList != null) {
				String recordAttributeList = wv_recordAttributeList.getString().trim();
				String recordAttributesCommand = ""; //$NON-NLS-1$
				int ordinal = 0;
				while (recordAttributeList.length() > 0) {
					int cp = recordAttributeList.indexOf(',');
					String recordAttributeName;
					if (cp < 0) {
						recordAttributeName = recordAttributeList.trim();
						recordAttributeList = ""; //$NON-NLS-1$
					} else {
						recordAttributeName = recordAttributeList.substring(0, cp).trim();
						recordAttributeList = recordAttributeList.substring(cp + 1).trim();
					}
					recordAttributesCommand += "TUPLE(ORDINAL(" + (ordinal += 10) + ")RELVARNAME(" + relvarName + ")RECORDTYPENAME(" + recordTypeName + ")ATTRIBUTENAME(" + recordAttributeName + "))"; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$
				}
				if (recordAttributesCommand.length() > 0) {
					recordAttributesCommand = "ADD RECORDATTRIBUTE,RECORDATTRIBUTE(" + recordAttributesCommand + ")"; //$NON-NLS-1$ //$NON-NLS-2$
					commandList.addLast(recordAttributesCommand);
				}
			}

			// Inquire whether this is the first record type or not
			String q_existingRecordTypes = "RESTRICT(RECORDTYPE,EQ(RELVARNAME,NAME(" + relvarName + ")))"; //$NON-NLS-1$//$NON-NLS-2$

			AbstractRelation rsp = startTransaction.execQuery(q_existingRecordTypes);
			// Set tuples = rsp.getTupleSet();
			// if (tuples.size() == 0) {
			// //It is the first record type for this relvar, record all the relvarattributes in this record
			//		        String q_relvarAttributes = "RESTRICT(RELVARATTRIBUTE,EQ(RELVARNAME,NAME("+relvarName+")))"; //$NON-NLS-1$//$NON-NLS-2$
			// rsp = dbc.execQuery(q_relvarAttributes);
			// tuples = rsp.getTupleSet();
			// int ordinal = 10;
			// Iterator i_tuples = tuples.iterator();
			//		        String recordAttributeRelationValue = ""; //$NON-NLS-1$
			// while (i_tuples.hasNext()) {
			// String tuple_tx = (String) i_tuples.next();
			// //tuple_tx = RELVARNAME(...)ATTRIBUTENAME(...)
			//		            tuple_tx = tuple_tx + "ORDINAL("+ordinal+")RECORDTYPENAME("+recordTypeName+")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			// ordinal += 10;
			//		            recordAttributeRelationValue = recordAttributeRelationValue + "TUPLE("+tuple_tx+")"; //$NON-NLS-1$//$NON-NLS-2$
			// }
			//		        String a_recordAttributes = "ADD RECORDATTRIBUTE,RECORDATTRIBUTE("+recordAttributeRelationValue+")"; //$NON-NLS-1$//$NON-NLS-2$
			// commandList.addLast(a_recordAttributes);
			// dbc.execMultipleStatementAndEndTransaction(commandList);
			// leave = true;
			// } else {
			if (rsp.size() > 0) {
				// It is not the first record type. So specification of a tupleindex is mandatory.
				if (wv_tupleIndexName == null) {
					throw new TupleIndexRequiredException(relvarName, getUserLocale());
				}
				// If it is the second, then we must check whether the first (and up until now
				// only one) already has a tupleindex. If that is the case, no problem. Else, we must prompt the user for
				// the name and storage specs of that tupleindex, which we must create.
				if (rsp.size() == 1) {
					// String existingRecordTypeTupleAttributes_tx = (String) tuples.getFirst();
					AbstractTuple existingRecordTypeTupleAttributes_map = (AbstractTuple) rsp.iterator().next();
					// No second tuple, check whether the only record type already has a tuple index
					//		            String cmd = "AGGREGATE(EXTEND(RESTRICT(TUPLEINDEX,EQ(RELVARNAME,NAME("+relvarName+"))),(ONE(INT(1)))),COUNT(PLUS(ONE)))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
					String cmd = "AGGREGATE(RESTRICT(TUPLEINDEX,EQ(RELVARNAME,NAME(" + relvarName + "))),COUNT(PLUS(INT(1))))"; //$NON-NLS-1$//$NON-NLS-2$
					rsp = startTransaction.execQuery(cmd);
					// tuples = rsp.getTupleSet();
					AbstractTuple tuple = (AbstractTuple) rsp.iterator().next();
					int count = Integer.parseInt(tuple.value("COUNT")); //$NON-NLS-1$
					if (count > 0) {
						// Tupleindex already exists - just execute what we have prepared
						startTransaction.execMultipleStatementAndEndTransaction(commandList);
						leave = true;
					} else {
						String existingRecordTypeName = existingRecordTypeTupleAttributes_map.value(ATTRIBUTENAMES.RECORDTYPENAME);

						popupPresentation("PromptTupleIndexForExistingRecordType"); //$NON-NLS-1$
						setSiraPriseServerPortPresentationValues(sirapriseServer);
						setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
						saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, relvarName);
						setPresentationValue("EXISTINGRECORDTYPENAME", new GenericStringValue(existingRecordTypeName)); //$NON-NLS-1$
						saveInFunctionContext("EXISTINGRECORDTYPENAME", existingRecordTypeName); //$NON-NLS-1$
						saveInFunctionContext("COMMANDLIST", commandList); //$NON-NLS-1$
					}
				} else {
					// There were already >1 record types, which guarantees us that the tupleindexes for the existing record
					// types are OK. Just execute the commands.
					startTransaction.execMultipleStatementAndEndTransaction(commandList);
					leave = true;
				}
			} else {
				// There were no record types, which guarantees us that no tupleindexes will be needed for the existing record
				// types are OK. Just execute the commands.
				startTransaction.execMultipleStatementAndEndTransaction(commandList);
				leave = true;
			}

		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_recordTypeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
		if (wv_recordTypeName != null) {
			setPresentationValue("LOCATORINDEXNAME", new GenericStringValue("L_" + wv_recordTypeName.getString())); //$NON-NLS-1$//$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		String presentationName = getPresentation().getName();
		if (presentationName.equalsIgnoreCase("RecordTypesCreate")) { //$NON-NLS-1$
			processRecordTypesCreate();
		} else {
			if (presentationName.equalsIgnoreCase("PromptTupleIndexForExistingRecordType")) { //$NON-NLS-1$
				processPromptTupleIndexForExistingRecordType();
			} else {
				throw new UnexpectedPresentationToProcessException(presentationName, getUserLocale());
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordTypesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}