package be.SIRAPRISE.webclient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.AttributeValueDistribution;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.Index;
import be.SIRAPRISE.client.jsba.IndexComponent;
import be.SIRAPRISE.client.jsba.RecordAttribute;
import be.SIRAPRISE.client.jsba.RecordType;
import be.SIRAPRISE.client.jsba.RelvarCardinality;
import be.SIRAPRISE.client.jsba.TupleIndex;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a record type from a physical database design
 * 
 * @author Erwin
 */
public class RecordTypesDelete extends RecordTypesWebClientFunction {

	/**
	 * Indicator telling whether the function can be left or not
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedRecordType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_recordTypeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
		String relvarName = wv_relvarName.getString().trim();
		String recordTypeName = wv_recordTypeName.getString().trim();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			String c_recordTypeName = "EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			String c_relvarName = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			String restrictCondition = "AND(" + c_recordTypeName + "," + c_relvarName + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			AbstractRelation r_recordType = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.RECORDTYPE + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_recordAttributes = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.RECORDATTRIBUTE + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_indexes = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.INDEX + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_indexComponents = startTransaction.execQuery("RESTRICT(SEMIJOIN(" + RELVARNAMES.INDEXCOMPONENT + ",RESTRICT(" + RELVARNAMES.INDEX + "," + c_recordTypeName + "))," + c_relvarName + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			AbstractRelation r_tupleIndex = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.TUPLEINDEX + "," + restrictCondition + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			AbstractRelation r_attributeValueDistribution = startTransaction.execQuery("RESTRICT(SEMIMINUS(" + RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION + ",SEMIJOIN(" + RELVARNAMES.INDEXATTRIBUTE + ",RESTRICT(" + RELVARNAMES.INDEX + ",NOT(" + c_recordTypeName + "))))," + c_relvarName + ")"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			AbstractRelation r_relvarCardinality = startTransaction.execQueryAndEndTransaction("RESTRICT(SEMIMINUS(" + RELVARNAMES.RELVARCARDINALITY + ",PROJECT(RESTRICT(" + RELVARNAMES.RECORDTYPE + ",NOT(" + c_recordTypeName + ")),(" + ATTRIBUTENAMES.RELVARNAME + ")))," + c_relvarName + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$

			if (r_recordType.size() < 1) {
				throw new NoSuchRecordTypeException(relvarName, recordTypeName, getUserLocale());
			}
			AbstractTuple tuple = (AbstractTuple) r_recordType.iterator().next();
			RecordType recordType = DBObjectFactory.getObject(tuple, RecordType.class);

			setPresentation("RecordTypesDeleteConfirm"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, wv_recordTypeName);
			setPresentationValue(ATTRIBUTENAMES.FILENAME, recordType.getFileName());
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, recordType.getStorageSpaceID());
			//			setPresentationValue(ATTRIBUTENAMES.INDEXNAME, recordType.getIndexName()); //$NON-NLS-1$

			setPresentationValue("RECORDATTRIBUTELIST", getWAARListValue("RECORDATTRIBUTELIST", r_recordAttributes, null)); //$NON-NLS-1$ //$NON-NLS-2$
			setPresentationValue("INDEXLIST", getWAARListValue("INDEXLIST", r_indexes, null)); //$NON-NLS-1$ //$NON-NLS-2$
			setPresentationValue("ATTRIBUTEVALUEDISTRIBUTIONSLIST", getWAARListValue("ATTRIBUTEVALUEDISTRIBUTIONSLIST", r_attributeValueDistribution, null)); //$NON-NLS-1$ //$NON-NLS-2$

			Map<String, Collection<?>> dbObjectsToBeDeleted = new HashMap<String, Collection<?>>();
			dbObjectsToBeDeleted.put(RELVARNAMES.RECORDTYPE, r_recordType.toObjectCollection(RecordType.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.RECORDATTRIBUTE, r_recordAttributes.toObjectCollection(RecordAttribute.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.INDEX, r_indexes.toObjectCollection(Index.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.INDEXCOMPONENT, r_indexComponents.toObjectCollection(IndexComponent.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.TUPLEINDEX, r_tupleIndex.toObjectCollection(TupleIndex.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION, r_attributeValueDistribution.toObjectCollection(AttributeValueDistribution.class));
			dbObjectsToBeDeleted.put(RELVARNAMES.RELVARCARDINALITY, r_relvarCardinality.toObjectCollection(RelvarCardinality.class));

			saveInFunctionContext("DBOBJECTSTOBEDELETED", dbObjectsToBeDeleted); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserData().getLocale());
		} finally {
			dbc.close();
		}
	}

	/**
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		WaarValue wv_relvarName = getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		if (wv_relvarName != null) { // Also called from doInitialLogic !!!

			if (getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME) != null) {
				processSelectedRecordType();
			} else {
				DBConnection dbc = getDBConnection(sirapriseServer);
				try {
					setPresentationValue("RECORDTYPELIST", getWAARListValue("RECORDTYPELIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction("RESTRICT(" + RELVARNAMES.RECORDTYPE + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + ((GenericStringValue) wv_relvarName).getString().trim() + ")))"), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				} catch (ConnectionClosedException e) {
					log(e);
					throw new DBProblem(e, getUserLocale());
				} catch (ErrorMessageException e) {
					log(e);
					throw getWAARApplicationException(e);
				} finally {
					dbc.close();
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		processSelectionPresentation();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	@SuppressWarnings("unchecked")
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RECORDTYPESSELECT)) {
			processSelectionPresentation();
		} else {
			SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
				Map<String, Collection<? extends DBObject>> dbObjectsToBeDeleted = (Map<String, Collection<? extends DBObject>>) getFromFunctionContextMandatory("DBOBJECTSTOBEDELETED"); //$NON-NLS-1$
				Set<DmlDeleteCommand> deleteCommands = new HashSet<DmlDeleteCommand>();
				for (Entry<String, Collection<? extends DBObject>> me : dbObjectsToBeDeleted.entrySet()) {
					for (DBObject dbObjectToBeDeleted : me.getValue()) {
						deleteCommands.add(startTransaction.dbDeleteCommand(me.getKey(), dbObjectToBeDeleted));
					}
				}
				startTransaction.execMultipleStatementAndEndTransaction(deleteCommands);
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RECORDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordTypesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}