package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.WAAR.PresentationLayer.*;

/**
 * Function to manage the details of record types
 * 
 * @author Erwin
 */
public class RecordTypesManage extends RecordTypesWebClientFunction {

	/**
	 * @throws WaarException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 */
	private void processManageRecordTypeDetails ( ) throws WaarException {
		// <OK> clicked on managedetails presentation ; try to modify dataspace id or filename
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_newRecordTypeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME));
		String newRecordTypeName = wv_newRecordTypeName.getString();
		GenericStringValue wv_oldRecordTypeName = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RECORDTYPENAME);
		String oldRecordTypeName = wv_oldRecordTypeName.getString();
		GenericIntegerValue wv_newStorageSpaceID = ((GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID));
		int newStorageSpaceID = wv_newStorageSpaceID.getInteger();
		GenericIntegerValue wv_oldStorageSpaceID = (GenericIntegerValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.STORAGESPACEID);
		int oldStorageSpaceID = wv_oldStorageSpaceID.getInteger();
		GenericStringValue wv_newFileName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME));
		String newFileName = wv_newFileName.getString();
		GenericStringValue wv_oldFileName = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.FILENAME);
		String oldFileName = wv_oldFileName.getString();
		GenericStringValue wv_newIndexName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.INDEXNAME));
		String newIndexName = wv_newIndexName.getString();
		GenericStringValue wv_oldIndexName = (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.INDEXNAME);
		String oldIndexName = wv_oldIndexName.getString();

		String scalarUpdateList = ""; //$NON-NLS-1$
		if (!(oldStorageSpaceID == newStorageSpaceID)) {
			scalarUpdateList = ATTRIBUTENAMES.STORAGESPACEID + "(INT(" + newStorageSpaceID + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (!(oldFileName.equalsIgnoreCase(newFileName))) {
			scalarUpdateList += ATTRIBUTENAMES.FILENAME + "(FILENAME(" + newFileName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (!(oldRecordTypeName.equalsIgnoreCase(newRecordTypeName))) {
			scalarUpdateList += ATTRIBUTENAMES.RECORDTYPENAME + "(NAME(" + newRecordTypeName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (!(oldIndexName.equalsIgnoreCase(newIndexName))) {
			scalarUpdateList += ATTRIBUTENAMES.INDEXNAME + "(NAME(" + newIndexName + "))"; //$NON-NLS-1$//$NON-NLS-2$
		}
		if (scalarUpdateList.length() > 0) {
			DBConnection dbc = getDBConnection(sirapriseServer);
			try {
				DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
				String cmd1 = "UPDATE " + RELVARNAMES.RECORDTYPE + "," + RELVARNAMES.RECORDTYPE + "(TUPLE(" + ATTRIBUTENAMES.RELVARNAME + "(" + ((GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME)).getString() + ")" + ATTRIBUTENAMES.RECORDTYPENAME + "(" + oldRecordTypeName + ")" + ATTRIBUTENAMES.INDEXNAME + "(" + oldIndexName + ")" + ATTRIBUTENAMES.FILENAME + "(" + oldFileName + ")" + ATTRIBUTENAMES.STORAGESPACEID + "(" + oldStorageSpaceID + "))),(" + scalarUpdateList + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$
				startTransaction.execMultipleStatementAndEndTransaction(new String[] { cmd1 });
				// save new values as old ones in the function context
				saveInFunctionContext(ATTRIBUTENAMES.FILENAME, wv_newFileName);
				saveInFunctionContext(ATTRIBUTENAMES.STORAGESPACEID, wv_newStorageSpaceID);
				saveInFunctionContext(ATTRIBUTENAMES.RECORDTYPENAME, wv_newRecordTypeName);
				saveInFunctionContext(ATTRIBUTENAMES.INDEXNAME, wv_newIndexName);
			} catch (ConnectionClosedException e) {
				// restore old values on the presentation
				setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, wv_oldRecordTypeName);
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				// restore old values on the presentation
				setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, wv_oldRecordTypeName);
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/**
	 * process the "Select Record Type" presentation
	 * 
	 * @throws WaarException
	 */
	private void processSelectedRecordType ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_recordTypeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
		saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
		saveInFunctionContext(ATTRIBUTENAMES.RECORDTYPENAME, wv_recordTypeName);

		refreshInfo(sirapriseServer, wv_relvarName, wv_recordTypeName);
	}

	/**
	 * @param sirapriseServer
	 * @param wv_relvarName
	 * @param wv_recordTypeName
	 * @throws WaarException
	 */
	private void refreshInfo (SiraPriseServer sirapriseServer, GenericStringValue wv_relvarName, GenericStringValue wv_recordTypeName) throws WaarException {
		String relvarName = wv_relvarName.getString().trim();
		String recordTypeName = wv_recordTypeName.getString().trim();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			AbstractRelation rsp = startTransaction.execQuery("RESTRICT(" + RELVARNAMES.RECORDTYPE + ",AND(EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + ")),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + "))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			// Set tuples = rsp.getTupleSet();
			if (rsp.size() < 1) {
				throw new NoSuchRecordTypeException(relvarName, recordTypeName, getUserLocale());
			}

			AbstractTuple tuple = (AbstractTuple) rsp.iterator().next();
			setPresentation("RecordTypesManageDetails"); //$NON-NLS-1$
			setSiraPriseServerPortPresentationValues(sirapriseServer);
			setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
			setPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME, wv_recordTypeName);

			String fileName = tuple.value(ATTRIBUTENAMES.FILENAME);
			WaarValue wv_fileName = new GenericStringValue(fileName);
			saveInFunctionContext(ATTRIBUTENAMES.FILENAME, wv_fileName);
			setPresentationValue(ATTRIBUTENAMES.FILENAME, wv_fileName);

			String storageSpaceID_tx = tuple.value(ATTRIBUTENAMES.STORAGESPACEID);
			int storageSpaceID = Integer.parseInt(storageSpaceID_tx);
			WaarValue wv_storageSpaceID = new GenericIntegerValue(storageSpaceID);
			saveInFunctionContext(ATTRIBUTENAMES.STORAGESPACEID, wv_storageSpaceID);
			setPresentationValue(ATTRIBUTENAMES.STORAGESPACEID, wv_storageSpaceID);

			String indexName = tuple.value(ATTRIBUTENAMES.INDEXNAME);
			WaarValue wv_indexName = new GenericStringValue(indexName);
			saveInFunctionContext(ATTRIBUTENAMES.INDEXNAME, wv_indexName);
			setPresentationValue(ATTRIBUTENAMES.INDEXNAME, wv_indexName);

			// Set the attribute list of this record type
			rsp = startTransaction.execQuery("RESTRICT(JOIN(" + RELVARNAMES.RECORDATTRIBUTE + "," + RELVARNAMES.ATTRIBUTE + "," + RELVARNAMES.ATTRIBUTEPHYSICALLENGTH + "),AND(EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + ")),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))),(ORDINAL)"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			ListValue lv = getWAARListValue("RECORDATTRIBUTELIST", rsp, null); //$NON-NLS-1$
			setPresentationValue("RECORDATTRIBUTELIST", lv); //$NON-NLS-1$

			// Set the index list of this record type
			rsp = startTransaction.execQuery("RENAME(RESTRICT(" + RELVARNAMES.INDEX + ",AND(EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordTypeName + ")),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))),(" + ATTRIBUTENAMES.INDEXNAME + ",IXNAME," + ATTRIBUTENAMES.FILENAME + ",IXFILENAME," + ATTRIBUTENAMES.STORAGESPACEID + ",IXSTORAGESPACEID))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
			lv = getWAARListValue("INDEXLIST", rsp, null); //$NON-NLS-1$
			setPresentationValue("INDEXLIST", lv); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME) != null) {
			processSelectedRecordType();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RECORDTYPESSELECT)) {
			// selection criteria entered, inquire catalog and switch to managedetails presentation
			processSelectedRecordType();
		} else {
			processManageRecordTypeDetails();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		refreshInfo(setSiraPriseServerPortPresentationValues(), (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME), (GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RECORDTYPENAME));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RECORDTYPESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordTypesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}