package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function that produces an overview of defined record types
 * 
 * @author Erwin
 */
public class RecordTypesOverview extends RecordTypesWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		GenericStringValue wv_fileName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.FILENAME);
		GenericIntegerValue wv_dataSpaceID = (GenericIntegerValue) getPresentationValue(ATTRIBUTENAMES.STORAGESPACEID);
		GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
		GenericStringValue wv_namePattern = (GenericStringValue) getPresentationValue("NAMEPATTERN"); //$NON-NLS-1$

		if (wv_fileName == null && wv_relvarName == null && wv_namePattern == null) {
			throw new PleaseEnterSelectionCriteriaException(getPresentation().getName(), getUserLocale());
		}

		String recordTypeQuery;
		String restrictCondition = ""; //$NON-NLS-1$
		if (wv_fileName != null) {
			String fileName = wv_fileName.getString().trim();
			restrictCondition = "EQ(" + ATTRIBUTENAMES.FILENAME + ",FILENAME(" + fileName + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			if (wv_dataSpaceID != null) {
				restrictCondition = "AND(" + restrictCondition + ",EQ(" + ATTRIBUTENAMES.STORAGESPACEID + ",INT(" + wv_dataSpaceID.getInteger() + ")))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
		} else {
			if (wv_dataSpaceID != null) {
				throw new StorageSpaceIDWithoutFileNameException(getUserLocale());
			}
		}

		String baseExpression = RELVARNAMES.RECORDTYPE;
		if (wv_namePattern != null) {
			if (wv_relvarName != null) {
				throw new BothNameAndPatternNotAllowedException(getUserLocale());
			}
			String nameCondition = "MATCHES(THE_STRING(" + ATTRIBUTENAMES.RELVARNAME + "),STRING(" + BracketParser.meta(wv_namePattern.getString().trim()) + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			if (restrictCondition.length() > 0) {
				restrictCondition = "AND(" + restrictCondition + "," + nameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
			} else {
				restrictCondition = nameCondition;
			}
		} else {
			if (wv_relvarName != null) {
				baseExpression = "JOIN(" + RelationValueSelectorFactory.getRelationValueSelector(RelationValueSelectorFactory.getNames(wv_relvarName.getString().trim()), ATTRIBUTENAMES.RELVARNAME, TYPENAMES.NAME) + "," + baseExpression + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}

		if (restrictCondition.length() > 0) {
			baseExpression = "RESTRICT(" + baseExpression + "," + restrictCondition + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		recordTypeQuery = "RENAME(" + baseExpression + ",(" + ATTRIBUTENAMES.RELVARNAME + ",RECORDRELVARNAME," + ATTRIBUTENAMES.FILENAME + ",RECORDFILENAME," + ATTRIBUTENAMES.STORAGESPACEID + ",RECORDSTORAGESPACEID))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			setPresentationValue("RECORDTYPELIST", getWAARListValue("RECORDTYPELIST", dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQueryAndEndTransaction(recordTypeQuery), null)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RecordTypesOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}