package be.SIRAPRISE.webclient;

import java.util.Set;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.DmlMultipleAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.NewAttributeDefaultValue;
import be.SIRAPRISE.client.jsba.RecordAttribute;
import be.SIRAPRISE.client.jsba.RelvarAttribute;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.*;

/**
 * Function to add an attribute to a relvar definition.
 * 
 * @author Erwin
 */
public class RelvarAttributesCreate extends RelvarAttributesWebClientFunction {

	/**
	 * 
	 */
	private static final String RECORDATTRIBUTEDETAILSCREATE = "RecordAttributeDetailsCreate"; //$NON-NLS-1$

	/**
	 * Leave the function or not after completion
	 */
	boolean leave = false;

	/**
	 * Processes the specified record attribute details
	 * 
	 * @throws WaarException
	 */
	private void processRecordAttributeDetailsCreatePresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$
			GenericStringValue wv_recordtypeName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RECORDTYPENAME);
			// possible TO DO : check the existence of the recordtype itself and allow the user to go create a new record type first by
			// switching to (invoking) the recordtypescreate function.
			String relvarName = ((GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.RELVARNAME)).getString();
			String attributeName = ((GenericStringValue) getFromFunctionContextMandatory(ATTRIBUTENAMES.ATTRIBUTENAME)).getString();

			final NewAttributeDefaultValue newAttributeDefaultValue = new NewAttributeDefaultValue(relvarName, attributeName, ((GenericStringValue) getPresentationValue("DEFAULTVALUE")).getString()); //$NON-NLS-1$

			DmlAddCommand dml1 = new RelvarAttribute(relvarName, attributeName).dbAddCommand(RELVARNAMES.RELVARATTRIBUTE);
			DmlAddCommand dml2 = newAttributeDefaultValue.dbAddCommand(RELVARNAMES.NEWATTRIBUTEDEFAULTVALUE);
			if (wv_recordtypeName != null) {
				String recordtypeName = wv_recordtypeName.getString();
				startTransaction.execDmlCommand(new DmlMultipleAssignmentCommand(new DmlAddCommand[] { dml1, dml2, new RecordAttribute(relvarName, recordtypeName, Math.max(10, 10 + Integer.parseInt(((AbstractTuple) startTransaction.execQuery("AGGREGATE(RESTRICT(" + RELVARNAMES.RECORDATTRIBUTE + ",AND(EQ(" + ATTRIBUTENAMES.RECORDTYPENAME + ",NAME(" + recordtypeName + ")),EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))),MAX(MAX(" + ATTRIBUTENAMES.ORDINAL + ")))").iterator().next()).value("MAX"))), attributeName).dbAddCommand(RELVARNAMES.RECORDATTRIBUTE) })); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
			} else {
				startTransaction.execDmlCommand(new DmlMultipleAssignmentCommand(new DmlAddCommand[] { dml1, dml2 }));
			}

			// And now clean up the newattributedefaultvalue
			startTransaction.execDmlCommandAndEndTransaction(newAttributeDefaultValue.dbDeleteCommand(RELVARNAMES.NEWATTRIBUTEDEFAULTVALUE));

			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/**
	 * Processes a request to add an attribute to a relvar heading. Processing involves querying whether that relvar is recorded or not, and dependingly display a screen to the user to prompt him for the appropriate record types where to add the attribute.
	 * 
	 * @throws WaarException
	 * @throws ExpectedBracketsMissingException
	 * @throws NoConnectionException
	 * @throws DBProblem
	 */
	private void processRelvarAttributesCreatePresentation ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			DBTransaction startTransaction = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())); //$NON-NLS-1$

			GenericStringValue wv_relvarName = (GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME);
			GenericStringValue wv_attributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME));
			String relvarName = wv_relvarName.getString().trim();
			Set<String> attributeNames = RelationValueSelectorFactory.getNames(wv_attributeName.getString().trim());

			if (startTransaction.execQuery("RESTRICT(" + RELVARNAMES.RECORDTYPE + ",EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")))").size() > 0) { //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				if (attributeNames.size() > 1) {
					// REMIND allow recordattribute creation (and default value provision) for each individual new attribute of a set >1
					throw new CannotCreateMultipleRecordAttributesException(getUserLocale());
				}
				setPresentation(RECORDATTRIBUTEDETAILSCREATE);
				setSiraPriseServerPortPresentationValues(sirapriseServer);
				setPresentationValue(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
				setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, wv_attributeName);
				saveInFunctionContext(ATTRIBUTENAMES.RELVARNAME, wv_relvarName);
				saveInFunctionContext(ATTRIBUTENAMES.ATTRIBUTENAME, wv_attributeName);
			} else {
				String tuples = ""; //$NON-NLS-1$
				for (String attributeName : attributeNames) {
					tuples += "TUPLE(" + ATTRIBUTENAMES.RELVARNAME + "(" + relvarName + ")" + ATTRIBUTENAMES.ATTRIBUTENAME + "(" + attributeName + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$
				}
				startTransaction.execDmlCommandAndEndTransaction("ADD " + RELVARNAMES.RELVARATTRIBUTE + "," + RELVARNAMES.RELVARATTRIBUTE + "(" + tuples + ")"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				leave = true;
			}
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("RELVARATTRIBUTESCREATE")) { //$NON-NLS-1$
			processRelvarAttributesCreatePresentation();
		} else {
			if (getPresentation().getName().equalsIgnoreCase(RECORDATTRIBUTEDETAILSCREATE)) {
				processRecordAttributeDetailsCreatePresentation();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarAttributesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}