package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NAMES.ATTRIBUTENAMES;
import be.SIRAPRISE.client.NAMES.RELVARNAMES;
import be.SIRAPRISE.client.jsba.RelvarAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 */
public class RelvarAttributesDelete extends RelvarAttributesWebClientFunction {

	/**
	 * Leave the function after exit or not
	 */
	boolean leave = false;

	/**
	 * @throws WaarException
	 */
	private void processSelectedRelvarAttribute ( ) throws WaarException {
		SiraPriseServer sirapriseServer = setSiraPriseServerPortPresentationValues();

		RelvarAttribute relvarAttribute = getRelvarAttribute(sirapriseServer);

		setPresentation("RelvarAttributesDeleteConfirm"); //$NON-NLS-1$
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, relvarAttribute.getRelvarName());
		setPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME, relvarAttribute.getAttributeName());

		saveInFunctionContext(RELVARNAMES.RELVARATTRIBUTE, relvarAttribute);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null && getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME) != null) {
			processSelectedRelvarAttribute();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RELVARATTRIBUTESSELECT)) {
			// filename entered, ask confirmation
			processSelectedRelvarAttribute();
		} else {
			RelvarAttribute relvarAttribute = (RelvarAttribute) getFromFunctionContextMandatory(RELVARNAMES.RELVARATTRIBUTE);
			String relvarName = relvarAttribute.getRelvarName();
			String attributeName = relvarAttribute.getAttributeName();
			String restrictCondition = ",AND(EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvarName + ")),EQ(" + ATTRIBUTENAMES.ATTRIBUTENAME + ",NAME(" + attributeName + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new String[] { relvarAttribute.dbDeleteCommand(RELVARNAMES.RELVARATTRIBUTE).getCommand(), ("DELETE " + RELVARNAMES.RECORDATTRIBUTE + ",RESTRICT(" + RELVARNAMES.RECORDATTRIBUTE + restrictCondition + ")"), ("DELETE " + RELVARNAMES.NEWATTRIBUTEDEFAULTVALUE + ",RESTRICT(" + RELVARNAMES.NEWATTRIBUTEDEFAULTVALUE + restrictCondition + ")") }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RELVARATTRIBUTESSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarAttributesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}