/**
 * 
 */
package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.RelvarAttribute;
import be.WAAR.PresentationLayer.*;

/**
 * @author Erwin
 *
 */
public abstract class RelvarAttributesWebClientFunction extends SiraPriseWebClientFunction {

	/**
	 * 
	 */
	static final String RELVARATTRIBUTESSELECT = "RelvarAttributesSelect"; //$NON-NLS-1$

	/**
	 * @param sirapriseServer
	 * @return
	 * @throws NoConnectionException
	 * @throws NoSuchRelvarAttributeException
	 * @throws DBProblem
	 * @throws WAARApplicationException
	 */
	final RelvarAttribute getRelvarAttribute (SiraPriseServer sirapriseServer) throws NoConnectionException, NoSuchRelvarAttributeException, DBProblem, WAARApplicationException {
		String relvarName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString();
		String attributeName = ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.ATTRIBUTENAME)).getString();
	
		DBConnection dbc = getDBConnection(sirapriseServer);
		try {
			AbstractRelation rsp = dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execQuery("RESTRICT(RELVARATTRIBUTE,AND(EQ(ATTRIBUTENAME,NAME(" + attributeName + ")),EQ(RELVARNAME,NAME(" + relvarName + "))))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ 
			if (rsp.size() == 0) {
				throw new NoSuchRelvarAttributeException(relvarName, attributeName, getUserLocale());
			}
			return rsp.toObjectCollection(RelvarAttribute.class).iterator().next();
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} catch (ConstructorMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (SettersMissingException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			log(e);
			throw new IllDefinedDBInterfaceClassException(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

}
