package be.SIRAPRISE.webclient;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.Relvar;
import be.WAAR.PresentationLayer.*;

/**
 * Function to create a new Relvar
 * 
 * @author Erwin
 */
public class RelvarsCreate extends RelvarsWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(new DmlAddCommand[] { new Relvar(((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARNAME)).getString().trim(), ((GenericStringValue) getPresentationValue(ATTRIBUTENAMES.RELVARPREDICATE)).getString().trim()).dbAddCommand(RELVARNAMES.RELVAR) }); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new DBProblem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw getWAARApplicationException(e);
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}
