package be.SIRAPRISE.webclient;

import java.util.Arrays;

import be.SIRAPRISE.client.*;
import be.SIRAPRISE.client.NAMES.*;
import be.SIRAPRISE.client.jsba.Relvar;
import be.WAAR.PresentationLayer.*;

/**
 * Function to delete a Relvar definition
 * 
 * @author Erwin
 */
public class RelvarsDelete extends RelvarsWebClientFunction {

	/**
	 * Leave the function after exit or not
	 */
	boolean leave = false;

	/**
	 * Processes the selected relvar Name
	 * 
	 * @throws WaarException
	 *             if any problem arose when querying the catalog for a relvar of this name.
	 */
	private void processSelectedRelvarName ( ) throws WaarException {
		SiraPriseServer siraPriseServer = setSiraPriseServerPortPresentationValues();

		Relvar relvar = getRelvar(siraPriseServer);

		setPresentation("RelvarsDeleteConfirm"); //$NON-NLS-1$
		setSiraPriseServerPortPresentationValues(siraPriseServer);
		setPresentationValue(ATTRIBUTENAMES.RELVARNAME, relvar.getName());
		saveInFunctionContext(RELVARNAMES.RELVAR, relvar);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setSiraPriseServerPortPresentationValues();

		if (getPresentationValue(ATTRIBUTENAMES.RELVARNAME) != null) {
			processSelectedRelvarName();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase(RELVARSSELECT)) {
			// filename entered, ask confirmation
			processSelectedRelvarName();
		} else {
			DBConnection dbc = getDBConnection(setSiraPriseServerPortPresentationValues());
			try {
				Relvar relvar = ((Relvar) getFromFunctionContextMandatory(RELVARNAMES.RELVAR));
				DmlDeleteCommand cmd1 = relvar.dbDeleteCommand(RELVARNAMES.RELVAR);
				String relvarNameCondition = "EQ(" + ATTRIBUTENAMES.RELVARNAME + ",NAME(" + relvar.getName() + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
				String cmd5 = "DELETE " + RELVARNAMES.KEY + ",RESTRICT(" + RELVARNAMES.KEY + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String cmd6 = "DELETE " + RELVARNAMES.KEYATTRIBUTE + ",PROJECT(RESTRICT(JOIN(" + RELVARNAMES.KEYATTRIBUTE + "," + RELVARNAMES.KEY + ")," + relvarNameCondition + "),(ERRORCODE,ATTRIBUTENAME))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				String cmd7 = "DELETE " + RELVARNAMES.TUPLECONSTRAINT + ",RESTRICT(" + RELVARNAMES.TUPLECONSTRAINT + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String cmd9 = "DELETE " + RELVARNAMES.CONSTRAINTMESSAGETEXT + ",SEMIJOIN(" + RELVARNAMES.CONSTRAINTMESSAGETEXT + ",RESTRICT(" + RELVARNAMES.TUPLECONSTRAINT + "," + relvarNameCondition + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				String cmd8 = "DELETE " + RELVARNAMES.RELVARATTRIBUTE + ",RESTRICT(" + RELVARNAMES.RELVARATTRIBUTE + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String cmd2 = "DELETE " + RELVARNAMES.RELVARCARDINALITY + ",RESTRICT(" + RELVARNAMES.RELVARCARDINALITY + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String cmd3 = "DELETE " + RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION + ",RESTRICT(" + RELVARNAMES.ATTRIBUTEVALUEDISTRIBUTION + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
//				String cmd4 = "DELETE " + RELVARNAMES.TRANSACTIONCONSTRAINT + ",RESTRICT(" + RELVARNAMES.TRANSACTIONCONSTRAINT + "," + relvarNameCondition + ")"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
//				String cmd10 = "DELETE " + RELVARNAMES.CONSTRAINTMESSAGETEXT + ",SEMIJOIN(" + RELVARNAMES.CONSTRAINTMESSAGETEXT + ",RESTRICT(TRANSACTIONCONSTRAINT," + relvarNameCondition + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, DDLCapture.getDDLCapture(isDDLCapture())).execMultipleStatementAndEndTransaction(Arrays.asList(new Object[] { cmd1, cmd2, cmd3, cmd5, cmd6, cmd7, cmd8, cmd9 })); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new DBProblem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw getWAARApplicationException(e);
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return RELVARSSELECT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "RelvarsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}